/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Name;
import com.beyondcron.core.Program;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.AgentJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class MessageJob
extends AgentJob {
    public static final String JSON_RECIPIENT = "recipient";
    public static final String JSON_SUBJECT = "subject";
    public static final String JSON_MESSAGE = "message";
    private static String hostName = (String)Configs.get("BEYONDCRON_AGENT_HOST_NAME_URL", Program.getOs());
    protected String recipient = "";
    protected String subject = "";
    protected String message = "";

    public MessageJob() {
        this.init();
    }

    public MessageJob(Job job) {
        super(job);
        this.init();
        if (job instanceof MessageJob) {
            this.message = ((MessageJob)job).message;
        }
    }

    public MessageJob(Name name) {
        super(name);
        this.init();
    }

    public MessageJob(Name name, String recipient, String subject, String message) {
        super(name);
        this.init();
        this.recipient = recipient != null ? recipient : "";
        this.subject = subject != null ? subject : "";
        this.message = message != null ? message : "";
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            super.setDefaults(defaults);
            if (this.recipient.isBlank()) {
                this.recipient = defaults.getTemplateValue(JSON_RECIPIENT);
            }
            if (this.subject.isBlank()) {
                this.subject = defaults.getTemplateValue(JSON_SUBJECT, false);
            }
            if (this.message.isBlank()) {
                this.message = defaults.getTemplateValue(JSON_MESSAGE, false);
            }
        }
    }

    private void init() {
        this.addAction(Job.Action.START);
        this.addAction(Job.Action.KILL);
    }

    @Override
    public String getHostName() {
        return hostName;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public MessageJob setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MessageJob setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageJob setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    protected Job expand(VariableFormatter formatter) {
        super.expand(formatter);
        this.subject = formatter.expand(this.getSubject());
        this.message = formatter.expand(this.getMessage());
        return this;
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof MessageJob) {
            MessageJob mThat = (MessageJob)that;
            JSONArray diff = Diff.diff(this.recipient, mThat.recipient);
            if (diff.length() > 0) {
                diffs.put(JSON_RECIPIENT, diff);
            }
            if ((diff = Diff.diff(this.subject, mThat.subject)).length() > 0) {
                diffs.put(JSON_SUBJECT, diff);
            }
            if ((diff = Diff.diff(this.message, ((MessageJob)that).message)).length() > 0) {
                diffs.put(JSON_MESSAGE, diff);
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        JSONObject json = super.toJSON(showSecrets);
        if (!StringUtils.isNullOrEmpty(this.recipient)) {
            json.put(JSON_RECIPIENT, this.recipient);
        }
        if (!StringUtils.isNullOrEmpty(this.subject)) {
            json.put(JSON_SUBJECT, this.subject);
        }
        if (!StringUtils.isNullOrEmpty(this.message)) {
            json.put(JSON_MESSAGE, this.message);
        }
        return json;
    }

    @Override
    public MessageJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.recipient = json.optString(JSON_RECIPIENT);
        this.subject = json.optString(JSON_SUBJECT);
        this.message = json.optString(JSON_MESSAGE);
        return this;
    }

    @Override
    public ProtoJob.Job.Builder toProto() {
        return this.toProto(false);
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.MessageJob.Builder builder = ProtoJob.MessageJob.newBuilder();
        if (!summary) {
            if (!StringUtils.isNullOrEmpty(this.recipient)) {
                builder.setRecipient(this.recipient);
            }
            if (!StringUtils.isNullOrEmpty(this.subject)) {
                builder.setSubject(this.subject);
            }
            if (!StringUtils.isNullOrEmpty(this.message)) {
                builder.setMessage(this.message);
            }
        }
        baseBuilder.setMessageExt(builder);
        return baseBuilder;
    }

    @Override
    public MessageJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.MessageJob proto = ProtoJob.Job.parseFrom(data).getMessageExt();
        super.fromProto(data);
        this.recipient = proto.hasRecipient() ? proto.getRecipient() : "";
        this.subject = proto.hasSubject() ? proto.getSubject() : "";
        this.message = proto.hasMessage() ? proto.getMessage() : "";
        return this;
    }
}

