/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Configs;
import com.beyondcron.core.JSON;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Output
implements Message<Output>,
JSON<Output> {
    private static final String MESSAGE_TAG = "output";
    public static final String JSON_HEAD = "head";
    public static final String JSON_TAIL = "tail";
    public static final String SEPARATOR = (String)Configs.get("beyondcron.output.separator");
    public static final String TRUNCATED = (String)Configs.get("beyondcron.output.line.truncated.suffix");
    public static final Pattern newlineMatcher = Pattern.compile("\\r?\\n");
    private List<String> head = new ArrayList<String>();
    private List<String> tail = new ArrayList<String>();
    private boolean hasTail = false;

    public Output() {
    }

    public Output(File file) throws IOException {
        this(new Builder().addFile(file));
    }

    public Output(TableFormatter table) {
        this(new Builder().addTable(table));
    }

    public Output(Exception exception) {
        Builder builder = new Builder();
        builder.addLine(exception.getClass().getName());
        for (StackTraceElement element : exception.getStackTrace()) {
            builder.addLine("  at " + element.toString());
        }
        this.setBuilder(builder);
    }

    public Output(Builder builder) {
        this.setBuilder(builder);
    }

    public Output(List<String> head, List<String> tail, boolean hasTail) {
        this.head.addAll(head);
        this.tail.addAll(tail);
        this.hasTail = hasTail;
    }

    private void setBuilder(Builder builder) {
        this.head.addAll(builder.getHead());
        if (builder.isTailFull() && builder.hasTail()) {
            this.tail.addAll(builder.getTail());
            this.hasTail = true;
        } else if (builder.hasTail()) {
            this.head.addAll(builder.getTail());
        }
    }

    public List<String> getHead() {
        return this.head;
    }

    public List<String> getTail() {
        return this.tail;
    }

    public boolean hasTail() {
        return this.hasTail;
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>(this.head);
        if (this.hasTail) {
            lines.addAll(this.getSeparator());
            lines.addAll(this.tail);
        }
        return lines;
    }

    public boolean isEmpty() {
        return this.head.isEmpty() && this.tail.isEmpty() && !this.hasTail;
    }

    public String getFirstLine() {
        if (!this.head.isEmpty()) {
            return this.head.get(0);
        }
        if (!this.tail.isEmpty()) {
            return this.tail.get(0);
        }
        return null;
    }

    public String getLastLine() {
        if (!this.tail.isEmpty()) {
            return this.tail.get(this.tail.size() - 1);
        }
        if (!this.head.isEmpty()) {
            return this.head.get(this.head.size() - 1);
        }
        return null;
    }

    public void write(File file) throws FileNotFoundException {
        PrintStream out = new PrintStream(file);
        for (String line : this.head) {
            out.println(line);
        }
        for (String line : this.getSeparator()) {
            out.println(line);
        }
        for (String line : this.tail) {
            out.println(line);
        }
    }

    public List<String> getSeparator() {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.tail.isEmpty()) {
            lines.addAll(Arrays.asList(SEPARATOR.split("\n", -1)));
        } else if (this.hasTail) {
            lines.addAll(Arrays.asList(SEPARATOR.split("\n")));
        }
        return lines;
    }

    public String toString() {
        return StringUtils.join("\n", this.getLines());
    }

    @Override
    public Output fromJSON(JSONObject json) throws JSONException {
        int i;
        JSONArray array;
        this.head.clear();
        if (json.has(JSON_HEAD)) {
            array = json.getJSONArray(JSON_HEAD);
            for (i = 0; i < array.length(); ++i) {
                this.head.add(array.getString(i));
            }
        }
        this.tail.clear();
        this.hasTail = json.has(JSON_TAIL);
        if (this.hasTail) {
            array = json.getJSONArray(JSON_TAIL);
            for (i = 0; i < array.length(); ++i) {
                this.tail.add(array.getString(i));
            }
        }
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        if (!this.head.isEmpty()) {
            json.put(JSON_HEAD, this.head);
        }
        if (this.hasTail || !this.tail.isEmpty()) {
            json.put(JSON_TAIL, this.tail);
        }
        return json;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Output.Builder toProto() {
        ProtoJob.Output.Builder builder = ProtoJob.Output.newBuilder();
        builder.addAllHead(this.head);
        builder.addAllTail(this.tail);
        if (this.hasTail) {
            builder.setHasTail(true);
        }
        return builder;
    }

    @Override
    public Output fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Output proto = ProtoJob.Output.parseFrom(data);
        this.head.clear();
        this.head.addAll((Collection<String>)proto.getHeadList());
        this.tail.clear();
        this.tail.addAll((Collection<String>)proto.getTailList());
        this.hasTail = proto.getHasTail();
        return this;
    }

    public static class Builder {
        private int maxLineLength;
        private int truncateLength;
        private int headLinesMax;
        private int tailLinesMax;
        private List<String> head = new ArrayList<String>();
        private List<String> tail = new ArrayList<String>();
        private boolean headFull;
        private boolean tailFull;
        private boolean fillTail;

        public Builder() {
            this((Integer)Configs.get("beyondcron.output.lines.head"), (Integer)Configs.get("beyondcron.output.lines.tail"), (Integer)Configs.get("beyondcron.output.line.length"));
        }

        public Builder(int headLines, int tailLines) {
            this(headLines, tailLines, (Integer)Configs.get("beyondcron.output.line.length"));
        }

        public Builder(int headLines, int tailLines, int maxLineLength) {
            this.headLinesMax = headLines;
            this.headFull = headLines < 1;
            this.tailLinesMax = tailLines;
            this.tailFull = false;
            this.fillTail = tailLines > 0;
            this.setMaxLineLength(maxLineLength);
        }

        public Output build() {
            return new Output(this);
        }

        public int getHeadLinesMax() {
            return this.headLinesMax;
        }

        public int getHeadLinesFree() {
            int i = this.headLinesMax - this.head.size();
            return Math.max(i, 0);
        }

        public int getTailLinesMax() {
            return this.tailLinesMax;
        }

        public int getTailLinesFree() {
            int i = this.tailLinesMax - this.tail.size();
            return Math.max(i, 0);
        }

        public int getMaxLineLength() {
            return this.maxLineLength;
        }

        private void setMaxLineLength(int length) {
            this.maxLineLength = length;
            this.truncateLength = length - TRUNCATED.length();
            if (this.truncateLength < 0) {
                this.truncateLength = 0;
            }
        }

        public List<String> getHead() {
            return this.head;
        }

        public boolean hasHead() {
            return !this.head.isEmpty();
        }

        public boolean isHeadFull() {
            return this.headFull;
        }

        public List<String> getTail() {
            return this.tail;
        }

        public boolean hasTail() {
            return this.tailFull || !this.tail.isEmpty();
        }

        public boolean isTailFull() {
            return this.tailFull;
        }

        public Builder addFile(File file) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                this.addLine(line);
            }
            in.close();
            return this;
        }

        public Builder addLines(String ... lines) {
            for (String line : lines) {
                this.addLine(line);
            }
            return this;
        }

        public Builder addLine(String line) {
            if (!this.headFull) {
                this.addHead(this.truncate(line));
            } else if (this.fillTail) {
                this.addTail(this.truncate(line));
            } else if (!this.tailFull) {
                this.tailFull = true;
            }
            return this;
        }

        public Builder addConcatenatedLines(String lines) {
            if (lines == null || lines.length() == 0) {
                return this;
            }
            int start = 0;
            Matcher matcher = newlineMatcher.matcher(lines);
            while (matcher.find()) {
                int end = matcher.start();
                this.addLine(lines.substring(start, end));
                start = matcher.end();
            }
            if (start < lines.length()) {
                this.addLine(lines.substring(start));
            }
            return this;
        }

        public Builder addTable(TableFormatter table) {
            Iterator<String> lines = table.iterator();
            while (lines.hasNext()) {
                this.addLine(lines.next());
            }
            return this;
        }

        public boolean appendHead(String line) {
            if (this.headFull) {
                return false;
            }
            this.head.add(this.truncate(line));
            if (this.head.size() >= this.headLinesMax) {
                this.headFull = true;
            }
            return !this.headFull;
        }

        public boolean prependTail(String line) {
            if (this.tailFull) {
                return false;
            }
            if (line.length() == 0 && this.tail.isEmpty()) {
                return true;
            }
            this.tail.add(0, this.truncate(line));
            if (this.tail.size() >= this.tailLinesMax) {
                this.tailFull = true;
            }
            return !this.tailFull;
        }

        public boolean appendTail(String line) {
            this.tail.add(this.truncate(line));
            if (this.tail.size() >= this.tailLinesMax) {
                this.tailFull = true;
            }
            return !this.tailFull;
        }

        private void addHead(String line) {
            this.head.add(line);
            if (this.head.size() >= this.headLinesMax) {
                this.headFull = true;
            }
        }

        private void addTail(String line) {
            if (this.tailFull) {
                this.tail.remove(0);
            } else if (this.tail.size() >= this.tailLinesMax) {
                this.tail.remove(0);
                this.tailFull = true;
            }
            this.tail.add(line);
        }

        private String truncate(String line) {
            if (line.length() < this.maxLineLength) {
                return line;
            }
            return line.substring(0, this.truncateLength) + TRUNCATED;
        }
    }
}

