/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.AgentJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SQLJob
extends AgentJob {
    static final Logger logger = LogUtils.getLogger(SQLJob.class);
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.SQLJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.PARAMETER, Property.Type.VARIABLE);
    public static final String JSON_URL = "url";
    public static final String JSON_SQL = "sql";
    private static String hostName = (String)Configs.get("BEYONDCRON_AGENT_HOST_NAME_URL", Program.getOs());
    protected URI url = null;
    private List<String> sql = new ArrayList<String>();

    public SQLJob() {
        this.init();
    }

    public SQLJob(Job job) {
        super(job);
        this.init();
        if (job instanceof SQLJob) {
            SQLJob j = (SQLJob)job;
            this.url = j.url;
            this.sql.addAll(j.sql);
        }
    }

    public SQLJob(Name name) {
        super(name);
        this.init();
    }

    public SQLJob(Name name, URI url, String ... sql) {
        super(name);
        this.init();
        this.setURL(url);
        this.setSQL(sql);
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            String s;
            super.setDefaults(defaults);
            if (this.url == null && !StringUtils.isNullOrEmpty(s = defaults.getTemplateValue(JSON_URL, false))) {
                try {
                    this.url = new URI(NetUtils.encodeBraces(s));
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_URL, s, e.getMessage());
                }
            }
            if (this.sql.isEmpty() && (s = defaults.getTemplateValue(JSON_SQL, false)) != null && !s.isBlank()) {
                this.setSQL(StringUtils.split(s));
            }
        }
    }

    private void init() {
        this.addAction(Job.Action.START);
        this.addAction(Job.Action.KILL);
    }

    @Override
    public Job.Type getType() {
        return Job.Type.SQL;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.PARAMETER;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return NetUtils.isEchoHost(this.url);
    }

    @Override
    public String canEnableReason() {
        if (StringUtils.isNullOrEmpty(this.url)) {
            return Localise.format("Job has no URL");
        }
        try {
            new URI(this.getFormatter().expand(NetUtils.decodeBraces(this.url.toString())));
        }
        catch (URISyntaxException e) {
            return Localise.format("Invalid URL");
        }
        if (this.sql.isEmpty()) {
            return "Job has no sql";
        }
        return super.canEnableReason();
    }

    @Override
    public String getHostName() {
        return hostName;
    }

    public URI getURL() {
        return this.url;
    }

    public SQLJob setURL(URI url) {
        this.url = NetUtils.stripQuery(url);
        Map<String, String> values = NetUtils.parseQuery(url);
        for (String name : values.keySet()) {
            this.setProperty(new Property(name, values.get(name), Property.Type.PARAMETER, name.equals("password")));
        }
        return this;
    }

    public List<String> getSQL() {
        return this.sql;
    }

    public boolean hasSQL() {
        return !this.sql.isEmpty();
    }

    public SQLJob clearSQL() {
        this.sql.clear();
        return this;
    }

    public SQLJob setSQL(List<String> sql) {
        this.sql.clear();
        this.sql.addAll(sql);
        return this;
    }

    public SQLJob setSQL(String ... sql) {
        return this.clearSQL().addInput(sql);
    }

    public SQLJob addInput(String ... sql) {
        this.sql.addAll(Arrays.asList(sql));
        return this;
    }

    @Override
    protected Job expand(VariableFormatter formatter) {
        super.expand(formatter);
        if (this.url != null) {
            String s = NetUtils.decodeBraces(this.url.toString());
            try {
                this.url = new URI(NetUtils.encodeBraces(formatter.expand(s)));
            }
            catch (URISyntaxException e) {
                Localise.logError(logger, "Could not expand %1$s - %2$s", s, e.getMessage());
            }
        }
        if (!this.sql.isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : this.sql) {
                lines.add(formatter.expand(line));
            }
            this.sql.clear();
            this.sql.addAll(lines);
        }
        return this;
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof SQLJob) {
            SQLJob sThat = (SQLJob)that;
            JSONArray diff = Diff.diff(NetUtils.decodeBraces(this.url.toString()), NetUtils.decodeBraces(sThat.url.toString()));
            if (diff.length() > 0) {
                diffs.put(JSON_URL, diff);
            }
            if ((diff = Diff.diff(this.sql, sThat.sql)).length() > 0) {
                diffs.put(JSON_SQL, diff);
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        JSONObject json = super.toJSON(showSecrets);
        if (this.url != null) {
            json.put(JSON_URL, NetUtils.decodeBraces(this.url.toString()));
        }
        if (!this.sql.isEmpty()) {
            JSONArray array = new JSONArray();
            for (String line : this.sql) {
                array.put(line);
            }
            json.put(JSON_SQL, array);
        }
        return json;
    }

    @Override
    public SQLJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        if (json.has(JSON_URL)) {
            try {
                this.url = new URI(NetUtils.encodeBraces(json.getString(JSON_URL)));
            }
            catch (URISyntaxException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_URL, json.get(JSON_URL).toString(), e.getMessage()));
            }
        } else {
            this.url = null;
        }
        this.sql.clear();
        if (json.has(JSON_SQL)) {
            JSONArray array = json.getJSONArray(JSON_SQL);
            for (int i = 0; i < array.length(); ++i) {
                this.sql.add(array.getString(i));
            }
        }
        return this;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.SQLJob.Builder builder = ProtoJob.SQLJob.newBuilder();
        if (!summary) {
            if (this.url != null) {
                builder.setUrl(this.url.toString());
            }
            for (String line : this.sql) {
                builder.addSql(line);
            }
        }
        baseBuilder.setSqlExt(builder);
        return baseBuilder;
    }

    @Override
    public SQLJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.SQLJob proto = ProtoJob.Job.parseFrom(data).getSqlExt();
        super.fromProto(data);
        try {
            this.url = proto.hasUrl() ? new URI(proto.getUrl()) : null;
        }
        catch (URISyntaxException e) {
            this.url = null;
            Localise.logError(logger, "Could not parse - %1$s - %2$s", proto.getUrl(), e.getMessage());
        }
        this.sql.clear();
        this.sql.addAll((Collection<String>)proto.getSqlList());
        return this;
    }
}

