/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Status
implements Message<Status>,
Comparable<Status>,
JSON<Status> {
    static final Logger logger = LogUtils.getLogger(Status.class);
    private static final String MESSAGE_TAG = "status";
    public static final String JSON_NAME = "name";
    public static final String JSON_STATE = "state";
    public static final String JSON_RESULT = "result";
    public static final String JSON_VALUE = "value";
    public static final String JSON_TIMESTAMP = "timestamp";
    public static final String JSON_START_TIMESTAMP = "startTimestamp";
    public static final String JSON_MESSAGE = "message";
    public static final String JSON_HAS_OUTPUT = "hasOutput";
    public static final String JSON_OUTPUT = "output";
    public static final String JSON_TRIGGER = "trigger";
    public static final int DEFAULT_VALUE = -1;
    private Name name = null;
    private State state = State.STOPPED;
    private Result result = Result.UNKNOWN;
    private int value = -1;
    private String message = null;
    private long timestamp;
    private long startTimestamp = this.timestamp = System.currentTimeMillis();
    private long nextExecution = -1L;
    private Trigger trigger = null;
    private boolean hasOutput = false;
    private Output output = null;

    public Status() {
        this.name = Name.ROOT;
    }

    protected Status(Status status) {
        try {
            this.fromProto(status.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception - %1$s", e.getMessage());
        }
    }

    public Status(Name name) {
        this(name, Job.Mode.ENABLED);
    }

    public Status(Name name, Job.Mode mode) {
        this.name = name;
        switch (mode) {
            case BYPASS: {
                this.setState(State.BYPASS);
                break;
            }
            case DISABLED: {
                this.setState(State.DISABLED);
                break;
            }
        }
    }

    public Status(Name name, State state) {
        this.name = name;
        this.setState(state);
    }

    public Status(Name name, Result result) {
        this.name = name;
        this.setResult(result);
    }

    public Status(Name name, State state, Result result) {
        this.name = name;
        this.state = state;
        this.result = result;
    }

    public Status(Name name, State state, Result result, int value, String message) {
        this.name = name;
        this.state = state;
        this.result = result;
        this.value = value;
        this.message = message;
    }

    public Status(Name name, Exception exception) {
        this.name = name;
        this.setException(exception);
    }

    public Name getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.state.isActive();
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public Status set(State state, Result result, int value, String message) {
        this.state = state;
        this.result = result;
        this.value = value;
        this.message = message;
        return this;
    }

    public State getState() {
        return this.state;
    }

    public Status setState(State state) {
        this.state = state;
        switch (state) {
            case SCHEDULED: {
                break;
            }
            case WAITING: {
                break;
            }
            case STOPPED: 
            case BYPASS: {
                this.value = 0;
                this.result = Result.SUCCESS;
                break;
            }
            default: {
                this.setResult(Result.UNKNOWN);
            }
        }
        return this;
    }

    public Status setMode(Job.Mode mode) {
        if (this.isInactive()) {
            switch (mode) {
                case BYPASS: {
                    this.state = State.BYPASS;
                    this.nextExecution = -1L;
                    break;
                }
                case DISABLED: {
                    this.state = State.DISABLED;
                    this.nextExecution = -1L;
                    break;
                }
            }
        }
        return this;
    }

    public Result getResult() {
        return this.result;
    }

    public Status setResult(Result result) {
        this.result = result;
        if (result == Result.UNKNOWN) {
            this.message = null;
            this.hasOutput = false;
            this.output = null;
            this.value = -1;
        }
        return this;
    }

    public int getExitValue() {
        return this.value;
    }

    public Status setExitValue(int value) {
        return this.setExitValue(value, value == 0);
    }

    public Status setExitValue(int value, boolean success) {
        return this.setExitValue(value, success, "");
    }

    public Status setExitValue(int value, boolean success, String message) {
        this.state = State.STOPPED;
        this.result = success ? Result.SUCCESS : Result.ERROR;
        this.value = value;
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Status setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean hasOutput() {
        return this.hasOutput;
    }

    public Output getOutput() {
        return this.output;
    }

    public Status setOutput(Output output) {
        boolean hasOutput = output != null && !output.isEmpty();
        return this.setOutput(hasOutput ? output : null, hasOutput);
    }

    public Status setOutput(Output output, boolean hasOutput) {
        this.output = output;
        this.hasOutput = hasOutput;
        return this;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Status setTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public boolean hasTrigger() {
        return this.trigger != null;
    }

    public Status setException(Exception exception) {
        String description;
        this.state = State.STOPPED;
        this.result = Result.EXCEPTION;
        this.message = exception.getMessage();
        if (StringUtils.isNullOrEmpty(this.message)) {
            this.message = exception.getClass().getSimpleName();
        }
        if (exception instanceof ServiceException && (description = ((ServiceException)exception).getDescription()) != null && !description.trim().isEmpty()) {
            this.setOutput(new Output.Builder().addLines(description.split("\\n")).build());
        }
        if (this.output == null || this.output.isEmpty()) {
            this.setOutput(new Output(exception));
        }
        return this;
    }

    public long getNextExecution() {
        return this.nextExecution;
    }

    public Status setNextExecution(Date nextExecution) {
        this.nextExecution = nextExecution != null ? nextExecution.getTime() : -1L;
        return this;
    }

    public Status setNextExecution(long nextExecution) {
        this.nextExecution = nextExecution;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Status setTimestamp(long timestamp) {
        return this.setTimestamp(timestamp, false);
    }

    public Status setTimestamp(long timestamp, boolean resetStartTimestamp) {
        this.timestamp = timestamp;
        if (resetStartTimestamp) {
            this.startTimestamp = timestamp;
        }
        return this;
    }

    public Status updateTimestamp() {
        return this.updateTimestamp(false);
    }

    public Status updateTimestamp(boolean resetStartTimestamp) {
        this.timestamp = System.currentTimeMillis();
        if (resetStartTimestamp) {
            this.startTimestamp = this.timestamp;
        }
        return this;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Status setStartTimestamp(long timestamp) {
        this.startTimestamp = timestamp;
        return this;
    }

    public long getRunTime() {
        return this.timestamp - this.startTimestamp;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.state.toString().toLowerCase());
        if (this.isInactive()) {
            l.add(this.result.toString().toLowerCase());
            if (this.result == Result.SUCCESS || this.result == Result.ERROR) {
                l.add(Integer.toString(this.value));
            }
            if (this.result != Result.UNKNOWN && this.message != null) {
                l.add(this.message);
            }
        }
        return StringUtils.join(" ", l);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Status)) {
            return false;
        }
        return this.compareTo((Status)obj) == 0;
    }

    @Override
    public int compareTo(Status that) {
        if (this == that) {
            return 0;
        }
        int i = this.name.compareTo(that.name);
        if (i != 0) {
            return i;
        }
        i = this.state.compareTo(that.state);
        if (i != 0) {
            return i;
        }
        return this.result.compareTo(that.result);
    }

    public int hashCode() {
        return this.state.hashCode() + this.result.hashCode();
    }

    @Override
    public Status fromJSON(JSONObject json) throws JSONException {
        try {
            this.name = new Name(json.getString(JSON_NAME));
        }
        catch (URISyntaxException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_NAME, json.get(JSON_NAME).toString(), e.getMessage()));
        }
        try {
            this.state = State.valueOf(json.getString(JSON_STATE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_STATE, json.get(JSON_STATE).toString()));
        }
        try {
            this.result = Result.valueOf(json.getString(JSON_RESULT).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_RESULT, json.get(JSON_RESULT).toString()));
        }
        this.value = json.getInt(JSON_VALUE);
        this.timestamp = json.getLong(JSON_TIMESTAMP);
        this.startTimestamp = json.has(JSON_START_TIMESTAMP) ? json.getLong(JSON_START_TIMESTAMP) : this.timestamp;
        this.message = json.has(JSON_MESSAGE) ? json.getString(JSON_MESSAGE) : null;
        this.hasOutput = json.has(JSON_HAS_OUTPUT) ? json.getBoolean(JSON_HAS_OUTPUT) : false;
        this.output = json.has(JSON_OUTPUT) ? new Output().fromJSON(json.getJSONObject(JSON_OUTPUT)) : null;
        this.trigger = json.has(JSON_TRIGGER) ? new Trigger(json.getString(JSON_TRIGGER)) : null;
        return this;
    }

    @Override
    public JSONObject toJSON() {
        return this.toJSON(true);
    }

    public JSONObject toJSON(boolean includeOutput) {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name.toString());
        json.put(JSON_STATE, (Object)this.state);
        json.put(JSON_RESULT, (Object)this.result);
        json.put(JSON_VALUE, this.value);
        json.put(JSON_TIMESTAMP, this.timestamp);
        json.put(JSON_START_TIMESTAMP, this.startTimestamp);
        if (!StringUtils.isNullOrEmpty(this.message)) {
            json.put(JSON_MESSAGE, this.message);
        }
        if (this.hasOutput) {
            json.put(JSON_HAS_OUTPUT, this.hasOutput);
            if (includeOutput && this.output != null) {
                json.put(JSON_OUTPUT, this.output.toJSON());
            }
        }
        if (this.trigger != null) {
            json.put(JSON_TRIGGER, this.trigger.toString());
        }
        return json;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Status.Builder toProto() {
        ProtoJob.Status.Builder builder = ProtoJob.Status.newBuilder();
        builder.setName(this.name.toProto());
        if (this.state != State.UNKNOWN) {
            builder.setState(this.state.toProto());
        }
        if (this.result != Result.UNKNOWN) {
            builder.setResult(this.result.toProto());
        }
        if (this.value != -1) {
            builder.setValue(this.value);
        }
        if (this.message != null && this.message.length() > 0) {
            builder.setMessage(this.message);
        }
        builder.setTimestamp(this.timestamp);
        if (this.startTimestamp != this.timestamp) {
            builder.setStartTimestamp(this.startTimestamp);
        }
        if (this.nextExecution >= 0L) {
            builder.setNextExecution(this.nextExecution);
        }
        if (this.hasOutput) {
            builder.setHasOutput(true);
            if (this.output != null) {
                builder.setOutput(this.output.toProto());
            }
        }
        if (this.trigger != null) {
            builder.setTrigger(this.trigger.toProto());
        }
        return builder;
    }

    @Override
    public Status fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Status proto = ProtoJob.Status.parseFrom(data);
        this.name = new Name(proto.getName());
        this.state = proto.hasState() ? State.fromProto(proto.getState()) : State.UNKNOWN;
        this.result = proto.hasResult() ? Result.fromProto(proto.getResult()) : Result.UNKNOWN;
        this.value = proto.hasValue() ? proto.getValue() : -1;
        this.message = proto.hasMessage() ? proto.getMessage() : null;
        this.timestamp = proto.getTimestamp();
        this.startTimestamp = proto.hasStartTimestamp() ? proto.getStartTimestamp() : this.timestamp;
        this.nextExecution = proto.hasNextExecution() ? proto.getNextExecution() : -1L;
        this.hasOutput = proto.getHasOutput();
        this.output = proto.hasOutput() ? new Output().fromProto(proto.getOutput().toByteArray()) : null;
        this.trigger = proto.hasTrigger() ? new Trigger().fromProto(proto.getTrigger().toByteArray()) : null;
        return this;
    }

    public static List<Status> sortByTimestamp(List<Status> statuses) {
        Collections.sort(statuses, (o1, o2) -> {
            long i = o1.timestamp - o2.timestamp;
            if (i < 0L) {
                return -1;
            }
            if (i > 0L) {
                return 1;
            }
            return 0;
        });
        return statuses;
    }

    public static List<Status> sortByStartTimestamp(List<Status> statuses) {
        Collections.sort(statuses, (o1, o2) -> {
            long i = o1.startTimestamp - o2.startTimestamp;
            if (i < 0L) {
                return -1;
            }
            if (i > 0L) {
                return 1;
            }
            i = o1.timestamp - o2.timestamp;
            if (i < 0L) {
                return -1;
            }
            if (i > 0L) {
                return 1;
            }
            return 0;
        });
        return statuses;
    }

    public static class Filter {
        private boolean empty = true;
        private Set<Result> resultFilters = new HashSet<Result>();
        private Set<State> stateFilters = new HashSet<State>();

        public Filter() {
        }

        public Filter(Collection<String> values) {
            this.add(values);
        }

        public Filter add(Collection<String> values) {
            for (String value : values) {
                this.add(value);
            }
            return this;
        }

        public Filter add(String value) {
            switch (value.toLowerCase()) {
                case "scheduled": {
                    this.add(State.SCHEDULED);
                    break;
                }
                case "waiting": {
                    this.add(State.WAITING);
                    break;
                }
                case "starting": {
                    this.add(State.STARTING);
                    break;
                }
                case "running": {
                    this.add(State.RUNNING);
                    break;
                }
                case "stopped": {
                    this.add(State.STOPPED);
                    break;
                }
                case "stopping": {
                    this.add(State.STOPPING);
                    break;
                }
                case "killing": {
                    this.add(State.KILLING);
                    break;
                }
                case "bypassed": {
                    this.add(State.BYPASS);
                    break;
                }
                case "disabled": {
                    this.add(State.DISABLED);
                    break;
                }
                case "success": {
                    this.add(Result.SUCCESS);
                    break;
                }
                case "error": {
                    this.add(Result.ERROR);
                    break;
                }
                case "missed": {
                    this.add(Result.MISSED);
                    break;
                }
                case "killed": {
                    this.add(Result.KILLED);
                    break;
                }
                case "exception": {
                    this.add(Result.EXCEPTION);
                    break;
                }
                case "failed": {
                    this.add(Result.ERROR);
                    this.add(Result.MISSED);
                    this.add(Result.KILLED);
                    this.add(Result.EXCEPTION);
                    break;
                }
                case "active": {
                    this.add(State.STARTING);
                    this.add(State.RUNNING);
                    this.add(State.STOPPING);
                    this.add(State.KILLING);
                    break;
                }
                case "inactive": {
                    this.add(State.STOPPED);
                    this.add(State.SCHEDULED);
                    this.add(State.WAITING);
                    this.add(State.STOPPED);
                    this.add(State.BYPASS);
                    this.add(State.DISABLED);
                    this.add(State.UNKNOWN);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Localise.format("unknown status %s", value));
                }
            }
            return this;
        }

        public Filter add(Result result) {
            this.resultFilters.add(result);
            this.empty = false;
            return this;
        }

        public Filter add(State state) {
            this.stateFilters.add(state);
            this.empty = false;
            return this;
        }

        public Set<Result> getResultFilters() {
            return this.resultFilters;
        }

        public Set<State> getStateFilters() {
            return this.stateFilters;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void reset() {
            this.resultFilters.clear();
            this.stateFilters.clear();
            this.empty = true;
        }

        public boolean matches(Status status) {
            if (this.empty) {
                return true;
            }
            if (this.stateFilters.contains((Object)status.getState())) {
                return true;
            }
            return status.isInactive() && this.resultFilters.contains((Object)status.getResult());
        }
    }

    public static enum Result {
        SUCCESS("Success"),
        ERROR("Error"),
        MISSED("Missed"),
        KILLED("Killed"),
        EXCEPTION("Exception"),
        FAILED("Failed"),
        UNKNOWN("Unknown");

        private final String label;
        protected static EnumMap<Result, ProtoJob.Status.Result> resultMap;

        private Result(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Result fromProto(ProtoJob.Status.Result result) {
            return resultMap.getA(result);
        }

        public ProtoJob.Status.Result toProto() {
            return resultMap.getB(this);
        }

        static {
            resultMap = new EnumMap<Result, Object>(Result.class, ProtoJob.Status.Result.class, UNKNOWN, null);
        }
    }

    public static enum State {
        SCHEDULED("Scheduled"),
        WAITING("Waiting"),
        STARTING("Starting"),
        RUNNING("Running"),
        STOPPING("Stopping"),
        STOPPED("Stopped"),
        KILLING("Killing"),
        BYPASS("Bypass"),
        DISABLED("Disabled"),
        UNKNOWN("Unknown");

        private final String label;
        protected static EnumMap<State, ProtoJob.Status.State> stateMap;

        private State(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isActive() {
            return this == STARTING || this == RUNNING || this == STOPPING || this == KILLING;
        }

        public static State fromProto(ProtoJob.Status.State state) {
            return stateMap.getA(state);
        }

        public ProtoJob.Status.State toProto() {
            return stateMap.getB(this);
        }

        static {
            stateMap = new EnumMap<State, Object>(State.class, ProtoJob.Status.State.class, UNKNOWN, null);
        }
    }
}

