/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Name;
import com.beyondcron.core.job.ConsolidatedStatus;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusConsolidator {
    private List<ConsolidatedStatus> statuses = new ArrayList<ConsolidatedStatus>();
    private Map<Name, List<Trigger>> currentTriggers = new HashMap<Name, List<Trigger>>();
    private long startTimestamp = 0L;

    public StatusConsolidator(List<Status> statuses) {
        for (Status status : Status.sortByStartTimestamp(statuses)) {
            this.addStatus(status);
        }
    }

    public boolean addStatus(Status status) {
        Name name = status.getName();
        List<Trigger> triggers = this.currentTriggers.get(name);
        if (triggers == null) {
            triggers = new ArrayList<Trigger>();
            this.currentTriggers.put(name, triggers);
        }
        if (this.startTimestamp != status.getStartTimestamp()) {
            triggers.clear();
            this.startTimestamp = status.getStartTimestamp();
        }
        if (status.hasTrigger()) {
            triggers.add(status.getTrigger());
        }
        if (status.isInactive()) {
            this.statuses.add(new ConsolidatedStatus(status, triggers));
            return true;
        }
        return false;
    }

    public List<ConsolidatedStatus> getStatuses() {
        Collections.sort(this.statuses, (o1, o2) -> {
            long i = o1.getTimestamp() - o2.getTimestamp();
            if (i < 0L) {
                return -1;
            }
            if (i > 0L) {
                return 1;
            }
            return 0;
        });
        return this.statuses;
    }

    public static List<ConsolidatedStatus> consolidate(List<Status> statuses) {
        return new StatusConsolidator(statuses).getStatuses();
    }
}

