/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Trigger
implements Message<Trigger>,
Comparable<Trigger> {
    private static final String MESSAGE_TAG = "trigger";
    private static final Pattern REGEX_TRIGGER = Pattern.compile("^([jsu]):(.*?)\\s*$");
    private Type type;
    private Name jobName;
    private String userName;

    public Trigger() {
        this(Type.SCHEDULE, null, null);
    }

    public Trigger(Name jobName) {
        this(Type.JOB, jobName, null);
    }

    public Trigger(User user) {
        this(Type.USER, null, user.getName());
    }

    public Trigger(String value) throws IllegalArgumentException {
        Matcher m = REGEX_TRIGGER.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException(Localise.format("invalid trigger value - %s", value));
        }
        String s = m.group(2);
        switch (m.group(1)) {
            case "j": {
                this.type = Type.JOB;
                if (!StringUtils.isNullOrEmpty(s)) {
                    try {
                        this.jobName = new Name(s);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(Localise.format("invalid trigger job name - %s", s));
                    }
                } else {
                    this.jobName = null;
                }
                this.userName = null;
                break;
            }
            case "s": {
                this.type = Type.SCHEDULE;
                this.jobName = null;
                this.userName = null;
                break;
            }
            case "u": {
                this.type = Type.USER;
                this.jobName = null;
                this.userName = s;
            }
        }
    }

    public Trigger(Type type, Name jobName, String userName) {
        this.type = type;
        this.jobName = jobName;
        this.userName = userName;
    }

    public Type getType() {
        return this.type;
    }

    public Name getJobName() {
        return this.type == Type.JOB ? this.jobName : null;
    }

    public String getUserName() {
        return this.type == Type.USER ? this.userName : null;
    }

    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean abbreviate) {
        if (this.type == Type.JOB) {
            if (this.jobName != null) {
                return this.jobName.toString();
            }
            return abbreviate ? Localise.format("job") : Localise.format("unknown job");
        }
        if (this.type == Type.USER) {
            if (this.userName != null) {
                return this.userName;
            }
            return abbreviate ? Localise.format("user") : Localise.format("unknown user");
        }
        return abbreviate ? "" : Localise.format("scheduler");
    }

    public String toString() {
        return this.type.prefix + this.getText(true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        return this.compareTo((Trigger)obj) == 0;
    }

    @Override
    public int compareTo(Trigger that) {
        return this.toString().compareTo(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Trigger.Builder toProto() {
        ProtoJob.Trigger.Builder builder = ProtoJob.Trigger.newBuilder();
        builder.setType(this.type.toProto());
        if (this.jobName != null) {
            builder.setJobName(this.jobName.toProto());
        } else if (this.userName != null) {
            builder.setUserName(this.userName);
        }
        return builder;
    }

    @Override
    public Trigger fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Trigger proto = ProtoJob.Trigger.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        this.jobName = proto.hasJobName() ? new Name(proto.getJobName()) : null;
        this.userName = proto.hasUserName() ? proto.getUserName() : null;
        return this;
    }

    public static enum Type {
        JOB("j:"),
        SCHEDULE("s:"),
        USER("u:");

        private String prefix;
        protected static EnumMap<Type, ProtoJob.Trigger.Type> resultMap;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public static Type fromProto(ProtoJob.Trigger.Type type) {
            return resultMap.getA(type);
        }

        public ProtoJob.Trigger.Type toProto() {
            return resultMap.getB(this);
        }

        static {
            resultMap = new EnumMap<Type, Object>(Type.class, ProtoJob.Trigger.Type.class, SCHEDULE, null);
        }
    }
}

