/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TriggerJob
extends Job {
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.TriggerJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.VARIABLE);
    public static final String JSON_DELAY = "delay";
    private static Map<Name, Future> activeTriggers = new HashMap<Name, Future>();
    private Period delay = new Period(0, Period.Unit.SECOND);

    public TriggerJob() {
        this.init();
    }

    public TriggerJob(Job job) {
        super(job);
        this.clearProperties();
        this.init();
        if (job instanceof TriggerJob) {
            this.delay = ((TriggerJob)job).delay.duplicate();
        }
    }

    public TriggerJob(Name name) {
        super(name);
        this.init();
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            String s;
            super.setDefaults(defaults);
            if (this.delay == null && !StringUtils.isNullOrEmpty(s = defaults.getTemplateValue(JSON_DELAY))) {
                try {
                    this.delay = new Period(s);
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_DELAY, s, e.getMessage());
                }
            }
        }
    }

    private void init() {
        this.addAction(Job.Action.START);
        this.addAction(Job.Action.KILL);
    }

    @Override
    public Job.Type getType() {
        return Job.Type.TRIGGER;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.VARIABLE;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return false;
    }

    public Period getDelay() {
        return this.delay;
    }

    public TriggerJob setDelay(Period delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public void execute(Job.Action action, long startTimestamp, Trigger trigger, Status triggerStatus) {
        Name name = this.getName();
        if (action == Job.Action.START) {
            if (!activeTriggers.containsKey(name)) {
                Future task = ThreadUtils.submit(() -> {
                    this.setStatus(new Status(name, Status.State.RUNNING));
                    long sleep = this.delay.getMilliseconds();
                    if (sleep > 0L) {
                        try {
                            Thread.sleep(sleep);
                            this.setStatus(new Status(name, Status.Result.SUCCESS).setExitValue(0));
                        }
                        catch (InterruptedException e) {
                            Localise.logDebug(logger, "Job %s killed", name);
                        }
                    } else {
                        this.setStatus(new Status(name, Status.Result.SUCCESS).setExitValue(0));
                    }
                    activeTriggers.remove(name);
                });
                activeTriggers.put(name, task);
            } else {
                this.setStatus(new Status(name, Status.Result.MISSED));
                Localise.logWarn(logger, "Job %s is already running", name);
            }
        } else if (action == Job.Action.KILL) {
            Future task = activeTriggers.get(name);
            if (task != null) {
                if (task.cancel(true)) {
                    activeTriggers.remove(name);
                    this.setStatus(new Status(name, Status.Result.KILLED));
                } else {
                    Localise.logError(logger, "Could not interrupt %s", name);
                }
            } else {
                this.setStatus(new Status(name, Status.State.STOPPED));
                Localise.logWarn(logger, "Job %s is not running", name);
            }
        } else {
            Localise.logError(logger, "Unsupported action %s", new Object[]{action});
        }
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONArray diff;
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof TriggerJob && (diff = Diff.diff(this.delay != null ? this.delay.toString().toUpperCase() : null, ((TriggerJob)that).delay != null ? ((TriggerJob)that).delay.toString().toUpperCase() : null)).length() > 0) {
            diffs.put(JSON_DELAY, diff);
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        JSONObject json = super.toJSON(showSecrets);
        if (this.delay.getValue() != 0) {
            json.put(JSON_DELAY, this.delay.toString(true));
        }
        return json;
    }

    @Override
    public TriggerJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        if (json.has(JSON_DELAY)) {
            try {
                this.delay = new Period(json.getString(JSON_DELAY), Period.Unit.HOUR);
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("Invalid %1$s - %2$s", JSON_DELAY, json.getString(JSON_DELAY)));
            }
        }
        return this;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.TriggerJob.Builder builder = ProtoJob.TriggerJob.newBuilder();
        if (!summary) {
            builder.setDelay(this.delay.toProto());
        }
        baseBuilder.setTriggerExt(builder);
        return baseBuilder;
    }

    @Override
    public TriggerJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.TriggerJob proto = ProtoJob.Job.parseFrom(data).getTriggerExt();
        super.fromProto(data);
        this.delay = proto.hasDelay() ? new Period().fromProto(proto.getDelay().toByteArray()) : new Period(0, Period.Unit.SECOND);
        return this;
    }
}

