/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.AgentJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class URLJob
extends AgentJob {
    static final Logger logger = LogUtils.getLogger(URLJob.class);
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.URLJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.PARAMETER, Property.Type.HEADER, Property.Type.VARIABLE);
    public static final String JSON_URL = "url";
    public static final String JSON_METHOD = "method";
    public static final String JSON_CONTENT = "content";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    private static String hostName = (String)Configs.get("BEYONDCRON_AGENT_HOST_NAME_URL", Program.getOs());
    private URL url = null;
    private Method method = Method.GET;
    private List<String> content = new ArrayList<String>();

    public URLJob() {
        this.init();
    }

    public URLJob(Job job) {
        super(job);
        this.init();
        if (job instanceof URLJob) {
            URLJob j = (URLJob)job;
            this.url = j.url;
            this.method = j.method;
        }
    }

    public URLJob(Name name) {
        super(name);
        this.init();
    }

    public URLJob(Name name, URL url, Method method) {
        super(name);
        this.init();
        this.setURL(url);
        this.method = method;
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            String s;
            super.setDefaults(defaults);
            if (this.url == null && !StringUtils.isNullOrEmpty(s = defaults.getTemplateValue(JSON_URL, false))) {
                try {
                    this.url = new URL(s);
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_URL, s, e.getMessage());
                }
            }
            if (this.method != null && !StringUtils.isNullOrEmpty(s = defaults.getTemplateValue(JSON_METHOD))) {
                try {
                    this.method = Method.valueOf(s.toUpperCase());
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_METHOD, s, e.getMessage());
                }
            }
            if (this.content.isEmpty() && (s = defaults.getTemplateValue(JSON_CONTENT, false)) != null && !s.isBlank()) {
                this.setContent(StringUtils.split(s));
            }
        }
    }

    private void init() {
        this.addAction(Job.Action.START);
        this.addAction(Job.Action.KILL);
    }

    @Override
    public Job.Type getType() {
        return Job.Type.URL;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.PARAMETER;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return NetUtils.isEchoHost(this.url);
    }

    @Override
    public String canEnableReason() {
        if (StringUtils.isNullOrEmpty(this.url)) {
            return Localise.format("Job has no URL");
        }
        return super.canEnableReason();
    }

    @Override
    public String getHostName() {
        return hostName;
    }

    public URL getURL() {
        return this.url;
    }

    public URLJob setURL(URL url) {
        this.url = url;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public URLJob setMethod(Method method) {
        this.method = method;
        return this;
    }

    public List<String> getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public URLJob clearContent() {
        this.content.clear();
        return this;
    }

    public URLJob setContent(List<String> lines) {
        return this.clearContent().addContent(lines);
    }

    public URLJob setContent(String ... lines) {
        return this.clearContent().addContent(lines);
    }

    public URLJob addContent(String ... lines) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, lines);
        return this.addContent(list);
    }

    public URLJob addContent(List<String> lines) {
        for (String line : lines) {
            Collections.addAll(this.content, line.split("\\n"));
        }
        if (!this.content.isEmpty() && this.content.get(0).isEmpty()) {
            this.clearContent();
        }
        return this;
    }

    public String getContentType() {
        return this.getContentType(false);
    }

    public String getContentType(boolean full) {
        for (Property property : this.getProperties(Property.Type.HEADER)) {
            if (!property.getName().equalsIgnoreCase(CONTENT_TYPE)) continue;
            return full ? property.getValue() : StringUtils.stripComment(property.getValue(), ";").toLowerCase();
        }
        return CONTENT_TYPE_FORM;
    }

    public String getEffectiveContent() {
        if (this.hasContent() || this.method == Method.GET) {
            return StringUtils.join("\n", this.content);
        }
        switch (this.getContentType()) {
            case "application/x-www-form-urlencoded": {
                return this.getFormContent();
            }
            case "application/json": {
                return this.getJsonContent();
            }
            case "text/plain": {
                return this.getTextContent();
            }
        }
        return "";
    }

    public String getFormContent() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (Property property : this.getProperties(Property.Type.PARAMETER)) {
            props.put(property.getName(), property.getValue());
        }
        return NetUtils.getParameterString(props);
    }

    public String getJsonContent() {
        JSONObject data = new JSONObject();
        for (Property property : this.getProperties(Property.Type.PARAMETER)) {
            data.put(property.getName(), property.getValue().replace("\\n", "\n"));
        }
        return data.length() > 0 ? data.toString() : "";
    }

    public String getTextContent() {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (Property property : this.getProperties(Property.Type.PARAMETER)) {
            lines.add((CallSite)((Object)(property.getName() + "=" + property.getValue())));
        }
        return StringUtils.join("\n", lines);
    }

    @Override
    protected Job expand(VariableFormatter formatter) {
        super.expand(formatter);
        if (this.url != null) {
            try {
                this.url = new URL(formatter.expand(this.url.toString()));
            }
            catch (MalformedURLException e) {
                Localise.logError(logger, "Could not expand %1$s - %2$s", this.url.toString(), e.getMessage());
            }
        }
        this.setContent(formatter.expand(StringUtils.join("\n", this.content)));
        return this;
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof URLJob) {
            URLJob uThat = (URLJob)that;
            JSONArray diff = Diff.diff(this.url, uThat.url);
            if (diff.length() > 0) {
                diffs.put(JSON_URL, diff);
            }
            if ((diff = Diff.diff((Object)this.method, (Object)uThat.method)).length() > 0) {
                diffs.put(JSON_METHOD, diff);
            }
            if ((diff = Diff.diff(this.content, uThat.content)).length() > 0) {
                diffs.put(JSON_CONTENT, diff);
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        JSONObject json = super.toJSON(showSecrets);
        if (this.url != null) {
            json.put(JSON_URL, this.url.toString());
        }
        if (this.method != Method.GET) {
            json.put(JSON_METHOD, this.method.toString());
        }
        if (this.hasContent()) {
            JSONArray array = new JSONArray();
            for (String line : this.content) {
                array.put(line);
            }
            json.put(JSON_CONTENT, array);
        }
        return json;
    }

    @Override
    public URLJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        if (json.has(JSON_URL)) {
            try {
                this.url = new URL(json.getString(JSON_URL));
            }
            catch (MalformedURLException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_URL, json.get(JSON_URL).toString(), e.getMessage()));
            }
        } else {
            this.url = null;
        }
        if (json.has(JSON_METHOD)) {
            try {
                this.method = Method.valueOf(json.getString(JSON_METHOD).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                if (json.getString(JSON_METHOD).equalsIgnoreCase("JSON")) {
                    this.method = Method.POST;
                    this.setProperty(new Property(CONTENT_TYPE, CONTENT_TYPE_JSON, Property.Type.HEADER, false));
                }
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_METHOD, json.get(JSON_METHOD).toString()));
            }
        } else {
            this.method = Method.GET;
        }
        if (json.has(JSON_CONTENT)) {
            JSONArray array = json.getJSONArray(JSON_CONTENT);
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < array.length(); ++i) {
                lines.add(array.getString(i));
            }
            this.setContent(lines);
        }
        return this;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.URLJob.Builder builder = ProtoJob.URLJob.newBuilder();
        if (!summary) {
            if (this.url != null) {
                builder.setUrl(this.url.toString());
            }
            builder.setMethod(this.method.toProto());
            if (this.hasContent()) {
                builder.addAllContent(this.content);
            }
        }
        baseBuilder.setUrlExt(builder);
        return baseBuilder;
    }

    @Override
    public URLJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.URLJob proto = ProtoJob.Job.parseFrom(data).getUrlExt();
        super.fromProto(data);
        try {
            this.url = proto.hasUrl() ? new URL(proto.getUrl()) : null;
        }
        catch (MalformedURLException e) {
            this.url = null;
            Localise.logError(logger, "Could not parse - %1$s - %2$s", proto.getUrl(), e.getMessage());
        }
        this.method = Method.fromProto(proto.getMethod());
        if (this.method == null) {
            if (proto.getMethod().toString().equals("JSON")) {
                this.method = Method.POST;
                this.setProperty(new Property(CONTENT_TYPE, CONTENT_TYPE_JSON, Property.Type.HEADER, false));
            } else {
                this.method = Method.GET;
                Localise.logError(logger, "Unsupported method, defaulting to GET - %1$s", proto.getMethod().toString());
            }
        }
        this.content.clear();
        this.content.addAll((Collection<String>)proto.getContentList());
        return this;
    }

    public static enum Method {
        GET("Get", "GET"),
        POST("Post", "POST"),
        PUT("Put", "PUT"),
        PATCH("Patch", "PATCH"),
        DELETE("Delete", "DELETE");

        private final String label;
        private final String method;
        private static final EnumMap<Method, ProtoJob.URLJob.Method> methodMap;

        private Method(String label, String method) {
            this.label = label;
            this.method = method;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMethod() {
            return this.method;
        }

        public static Method fromProto(ProtoJob.URLJob.Method method) {
            return methodMap.getA(method);
        }

        public ProtoJob.URLJob.Method toProto() {
            return methodMap.getB(this);
        }

        static {
            methodMap = new EnumMap<Method, ProtoJob.URLJob.Method>(Method.class, ProtoJob.URLJob.Method.class);
        }
    }
}

