/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.property;

import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;

public class PropertyValidator {
    static final Logger logger = LogUtils.getLogger(PropertyValidator.class);
    private static Map<String, PropertyValidator> validators = new HashMap<String, PropertyValidator>();
    private HazelcastInstance hazelcast;
    private MultiMap<Name, Property> properties;

    public static synchronized PropertyValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        PropertyValidator validator = validators.get(name);
        if (validator == null) {
            validator = new PropertyValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected PropertyValidator(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.properties = Hazelcast.getPropertyMap(hazelcast);
    }

    public Collection<Name> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties(Name group) {
        return this.getProperties(group, false);
    }

    public Collection<Property> getProperties(Name group, boolean includeParent) {
        HashMap<String, Property> m = new HashMap<String, Property>();
        if (this.properties.containsKey((Object)group)) {
            for (Property property : this.properties.get((Object)group)) {
                m.put(property.getName(), property);
            }
        }
        if (includeParent) {
            Name parent = group;
            while (!parent.isRoot()) {
                if (!this.properties.containsKey((Object)(parent = parent.isRootGroup() ? Name.ROOT : parent.getGroup()))) continue;
                for (Property property : this.getProperties(parent)) {
                    m.putIfAbsent(property.getName(), property);
                }
            }
        }
        return m.values();
    }

    public Collection<Property> getProperties(Name group, String name) {
        LinkedList<Property> list = new LinkedList<Property>();
        while (group != null) {
            for (Property property : this.properties.get((Object)group)) {
                if (!property.getName().equals(name)) continue;
                list.addFirst(property);
            }
            group = group.isRootGroup() ? (group.isRoot() ? null : Name.ROOT) : group.getGroup();
        }
        return list;
    }

    public Property getProperty(Name group, String name) {
        for (Property property : this.getProperties(group, true)) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public boolean hasProperty(Name group) {
        return group != null && this.properties.containsKey((Object)group);
    }

    public boolean hasProperty(Name group, String name) {
        if (group == null) {
            return false;
        }
        IExecutorService executor = this.hazelcast.getExecutorService("GroupNameExists");
        try {
            return (Boolean)executor.submitToKeyOwner((Callable)new GroupNameExists(group, name), (Object)group).get();
        }
        catch (Exception e) {
            logger.error("unexpected error checking in Property {}:{} exists - {}", (Object)group.toString(), (Object)name, (Object)e.getMessage());
            return false;
        }
    }

    private static class GroupNameExists
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Name group;
        private String name;

        private GroupNameExists() {
        }

        public GroupNameExists(Name group, String name) {
            this.group = group;
            this.name = name;
        }

        @Override
        public Boolean call() {
            MultiMap<Name, Property> properties = Hazelcast.getPropertyMap(this.hazelcast);
            for (Property property : properties.get((Object)this.group)) {
                if (!property.getName().equals(this.name)) continue;
                return true;
            }
            return false;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.group.toProto().build().toByteArray());
            out.writeUTF(this.name);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.group = new Name().fromProto(in.readByteArray());
            this.name = in.readUTF();
        }
    }
}

