/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.property.schemas;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Property;
import com.beyondcron.core.property.Schema;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuResource
extends Schema {
    public static String NAME = "cpu";
    private static final Pattern regex = Pattern.compile("^(\\d+(\\.\\d+)?)$");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Property.Type getType() {
        return Property.Type.RESOURCE;
    }

    @Override
    public boolean isValid(String value) {
        Matcher matcher = regex.matcher(value);
        return matcher.find() && (double)Float.parseFloat(matcher.group(1)) > 0.0;
    }

    @Override
    public String getValueMessage() {
        return Localise.format("Value must be a decimal number");
    }
}

