/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.property.schemas;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.Property;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.property.Schema;

public class EchoRun
extends Schema {
    public static String NAME = "echo.run";
    public static PeriodConfig config = (PeriodConfig)Configs.getConfig(NAME);
    private String message = "";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Property.Type getType() {
        return Property.Type.VARIABLE;
    }

    @Override
    public boolean isValid(String value) {
        try {
            this.message = config.validate(new Period(value));
        }
        catch (IllegalArgumentException e) {
            this.message = Localise.format("%1$s is not a valid period", value);
        }
        return StringUtils.isNullOrEmpty(this.message);
    }

    @Override
    public String getValueMessage() {
        return this.message != null ? this.message : "";
    }
}

