/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.property.schemas;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.property.Schema;

public class JobMode
extends Schema {
    public static String NAME = ":job-mode";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Property.Type getType() {
        return Property.Type.SYSTEM;
    }

    @Override
    public Schema.Scope getScope() {
        return Schema.Scope.GROUP;
    }

    @Override
    public boolean isValid(String value) {
        try {
            return Job.Mode.valueOf(value.toUpperCase()) != Job.Mode.ENABLED;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String getValueMessage() {
        return Localise.format("Value must be '%1$s' or '%2$s'", Job.Mode.ENABLED.getLabel().toLowerCase(), Job.Mode.DISABLED.getLabel().toLowerCase());
    }

    @Override
    public String normalise(String value) {
        return value.toLowerCase();
    }

    @Override
    public boolean canUnset() {
        return false;
    }
}

