/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.CalendarScheduleBuilder;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.ScheduleBuilder;

public class CalendarSchedule
extends Schedule {
    public static final String JSON_BOUNDARY = "boundary";
    public static final String JSON_OFFSET_DIRECTION = "direction";
    public static final String JSON_OFFSET = "offset";
    private Boundary boundary = Boundary.START;
    private Direction offsetDirection = Direction.BEFORE;
    private Period offset = new Period(0, Period.Unit.SECOND);

    public CalendarSchedule() {
    }

    public CalendarSchedule(Boundary boundary) {
        this(null, Job.Action.START, boundary, Direction.BEFORE, new Period(0, Period.Unit.SECOND));
    }

    public CalendarSchedule(Boundary boundary, Direction offsetDirection, Period offset) {
        this(null, Job.Action.START, boundary, offsetDirection, offset);
    }

    public CalendarSchedule(Job job, Job.Action action, Boundary boundary, Direction offsetDirection, Period offset) {
        super(job, action);
        this.boundary = boundary;
        this.offsetDirection = offsetDirection;
        this.offset = offset;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public Direction getOffsetDirection() {
        return this.offsetDirection;
    }

    public Period getOffset() {
        return this.offset;
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.CALENDAR;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        if (this.offset.getValue() != 0) {
            if (this.boundary == Boundary.BOTH) {
                if (this.offsetDirection == Direction.INSIDE || this.offsetDirection == Direction.OUTSIDE) {
                    return Localise.format("%1$s %2$s calendar event boundaries", new Object[]{this.offset.toString(), this.offsetDirection}).toLowerCase();
                }
                return Localise.format("%1$s %2$s start and end of calendar events", new Object[]{this.offset.toString(), this.offsetDirection}).toLowerCase();
            }
            return Localise.format("%1$s %2$s %3$s of calendar events", new Object[]{this.offset.toString(), this.offsetDirection, this.boundary}).toLowerCase();
        }
        return String.format("%s of calendar events", this.boundary == Boundary.BOTH ? "start and end" : this.boundary.toString().toLowerCase());
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return CalendarScheduleBuilder.calendarSchedule(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.boundary != Boundary.START) {
            json.put(JSON_BOUNDARY, this.boundary.toString());
        }
        if (this.offsetDirection != Direction.BEFORE) {
            json.put(JSON_OFFSET_DIRECTION, this.offsetDirection.toString());
        }
        if (this.offset.getValue() != 0) {
            json.put(JSON_OFFSET, this.offset.toString(true));
        }
        return json;
    }

    @Override
    public CalendarSchedule fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        if (json.has(JSON_BOUNDARY)) {
            try {
                this.boundary = Boundary.valueOf(json.getString(JSON_BOUNDARY).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_BOUNDARY, json.getString(JSON_BOUNDARY)));
            }
        } else {
            this.boundary = Boundary.START;
        }
        if (json.has(JSON_OFFSET_DIRECTION)) {
            try {
                this.offsetDirection = Direction.valueOf(json.getString(JSON_OFFSET_DIRECTION).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_OFFSET_DIRECTION, json.getString(JSON_OFFSET_DIRECTION)));
            }
        } else {
            this.offsetDirection = Direction.BEFORE;
        }
        try {
            this.offset = new Period(json.optString(JSON_OFFSET, "0 seconds"), Period.Unit.HOUR);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_OFFSET, json.optString(JSON_OFFSET)));
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.CalendarSchedule.Builder builder = ProtoJob.CalendarSchedule.newBuilder();
        if (this.boundary != Boundary.START) {
            builder.setBoundary(this.boundary.toProto());
        }
        if (this.offsetDirection != Direction.BEFORE) {
            builder.setOffsetDirection(this.offsetDirection.toProto());
        }
        if (this.offset.getValue() != 0) {
            builder.setOffset(this.offset.toProto());
        }
        baseBuilder.setCalendarExt(builder);
        return baseBuilder;
    }

    @Override
    public CalendarSchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.CalendarSchedule proto = ProtoJob.Schedule.parseFrom(data).getCalendarExt();
        super.fromProto(data);
        this.boundary = Boundary.fromProto(proto.getBoundary());
        this.offsetDirection = Direction.fromProto(proto.getOffsetDirection());
        if (proto.hasOffset()) {
            this.offset.fromProto(proto.getOffset().toByteArray());
        }
        return this;
    }

    public static enum Direction {
        BEFORE,
        AFTER,
        INSIDE,
        OUTSIDE;

        static EnumMap<Direction, ProtoJob.CalendarSchedule.Direction> directionMap;

        public static Direction fromProto(ProtoJob.CalendarSchedule.Direction direction) {
            return directionMap.getA(direction);
        }

        public ProtoJob.CalendarSchedule.Direction toProto() {
            return directionMap.getB(this);
        }

        static {
            directionMap = new EnumMap<Direction, ProtoJob.CalendarSchedule.Direction>(Direction.class, ProtoJob.CalendarSchedule.Direction.class);
        }
    }

    public static enum Boundary {
        START,
        END,
        BOTH;

        static EnumMap<Boundary, ProtoJob.CalendarSchedule.Boundary> boundaryMap;

        public static Boundary fromProto(ProtoJob.CalendarSchedule.Boundary boundary) {
            return boundaryMap.getA(boundary);
        }

        public ProtoJob.CalendarSchedule.Boundary toProto() {
            return boundaryMap.getB(this);
        }

        static {
            boundaryMap = new EnumMap<Boundary, ProtoJob.CalendarSchedule.Boundary>(Boundary.class, ProtoJob.CalendarSchedule.Boundary.class);
        }
    }
}

