/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Period;
import com.beyondcron.core.schedule.CalendarSchedule;
import com.beyondcron.core.schedule.CalendarTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.spi.MutableTrigger;

public class CalendarScheduleBuilder
extends ScheduleBuilder<CalendarTrigger> {
    private CalendarSchedule.Boundary boundary = CalendarSchedule.Boundary.START;
    private CalendarSchedule.Direction offsetDirection = CalendarSchedule.Direction.BEFORE;
    private Period offset = new Period(0, Period.Unit.SECOND);

    protected CalendarScheduleBuilder() {
    }

    public static CalendarScheduleBuilder calendarSchedule() {
        return new CalendarScheduleBuilder();
    }

    public static CalendarScheduleBuilder calendarSchedule(CalendarSchedule schedule) {
        return CalendarScheduleBuilder.calendarSchedule().withBoundary(schedule.getBoundary()).withOffsetDirection(schedule.getOffsetDirection()).withOffset(schedule.getOffset());
    }

    public CalendarScheduleBuilder withBoundary(CalendarSchedule.Boundary boundary) {
        this.boundary = boundary;
        return this;
    }

    public CalendarScheduleBuilder withOffsetDirection(CalendarSchedule.Direction offsetDirection) {
        this.offsetDirection = offsetDirection;
        return this;
    }

    public CalendarScheduleBuilder withOffset(Period offset) {
        this.offset = offset;
        return this;
    }

    protected MutableTrigger build() {
        CalendarTrigger trigger = new CalendarTrigger();
        trigger.setBoundary(this.boundary);
        trigger.setOffsetDirection(this.offsetDirection);
        trigger.setOffset(this.offset);
        return trigger;
    }
}

