/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Localise;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.message.DateTime;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;

public class DateSchedule
extends Schedule {
    public static final String JSON_WHEN = "when";
    public static String dateTimeFormat = "HH:mm:ss dd/MM/yyyy";
    private LocalDateTime dateTime;

    protected DateSchedule() {
    }

    public DateSchedule(LocalDateTime dateTime) {
        this(null, Job.Action.START, dateTime);
    }

    public DateSchedule(Job job, Job.Action action, LocalDateTime dateTime) {
        super(job, action);
        this.dateTime = dateTime;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.DATE;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        return TimeUtils.format(this.dateTime, timeZone);
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return SimpleScheduleBuilder.simpleSchedule();
    }

    @Override
    protected Date getStartTime() {
        return TimeUtils.getDate(this.dateTime, this.getTimeZone());
    }

    @Override
    public int compareTo(Schedule that) {
        if (!(that instanceof DateSchedule)) {
            return super.compareTo(that);
        }
        return this.dateTime.compareTo(((DateSchedule)that).dateTime);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(JSON_WHEN, this.dateTime.format(DateTimeFormatter.ofPattern(dateTimeFormat)));
        return json;
    }

    @Override
    public DateSchedule fromJSON(JSONObject json) {
        return this.fromJSON(json, TimeUtils.timeZoneUTC);
    }

    public DateSchedule fromJSON(JSONObject json, TimeZone timeZone) {
        super.fromJSON(json);
        String value = json.optString(JSON_WHEN, "");
        try {
            this.dateTime = LocalDateTime.parse(value, DateTimeFormatter.ofPattern(dateTimeFormat));
        }
        catch (DateTimeParseException e) {
            throw new JSONException(Localise.format("invalid %1$% - %2$%", JSON_WHEN, value));
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.DateSchedule.Builder builder = ProtoJob.DateSchedule.newBuilder();
        builder.setDateTime(new DateTime(this.dateTime).toProto());
        baseBuilder.setDateExt(builder);
        return baseBuilder;
    }

    @Override
    public DateSchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.DateSchedule proto = ProtoJob.Schedule.parseFrom(data).getDateExt();
        super.fromProto(data);
        if (proto.hasDateTime()) {
            this.dateTime = new DateTime(proto.getDateTime()).getDateTime();
        } else {
            this.dateTime = TimeUtils.getLocalDateTime(new Date(proto.getTime()), this.getTimeZone());
            logger.warn("parsing legacy date/time in DateSchedule {} - {}", (Object)Long.toString(proto.getTime()), (Object)this.dateTime.toString());
        }
        return this;
    }
}

