/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Day;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Time;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;

public class MonthlySchedule
extends Schedule {
    private static final Logger logger = LogUtils.getLogger(MonthlySchedule.class);
    public static final String JSON_DAY = "day";
    public static final String JSON_TIME = "time";
    public static final String JSON_DAY_OF_MONTH = "dayOfMonth";
    public static final String JSON_POSITION = "position";
    public static final String JSON_LAST = "last";
    public static final String LAST_DAY = "DAY";
    private Time time;
    private Day day;
    private int position;
    boolean last;
    private CronExpression expression;
    private String definition;

    protected MonthlySchedule() {
    }

    public MonthlySchedule(Time time, int position) {
        this(null, Job.Action.START, time, Day.DAILY, position, false);
    }

    public MonthlySchedule(Time time, Day day, int position) {
        this(null, Job.Action.START, time, day, position, false);
    }

    public MonthlySchedule(Time time, Day day, int position, boolean last) {
        this(null, Job.Action.START, time, day, position, last);
    }

    public MonthlySchedule(Job job, Job.Action action, Time time, Day day, int position, boolean last) {
        super(job, action);
        this.time = time;
        this.day = day;
        this.position = position;
        this.last = last;
        this.init();
    }

    private void validate() {
        if (this.position >= 1 && this.position <= 31) {
            if (this.last) {
                if (this.day != Day.DAILY && this.position != 1) {
                    throw new IllegalArgumentException(Localise.format("position (%1$d) must be 1 when last and not day", this.position));
                }
            } else if (this.day.getDays().size() == 1 && this.position > 5) {
                throw new IllegalArgumentException(Localise.format("position (%1$d) must be in the range 1-5 when day is in the range mon-sun", this.position));
            }
        } else {
            throw new IllegalArgumentException(Localise.format("position (%1$d) must be in the range 1 - 31", this.position));
        }
    }

    private void init() {
        String dayOfWeek;
        this.validate();
        this.expression = null;
        String cronDayOfMonth = "?";
        String cronDayOfWeek = "?";
        if (this.last) {
            if (this.day == Day.DAILY || this.day == Day.WEEKDAY) {
                if (this.day == Day.DAILY) {
                    if (this.position > 1) {
                        cronDayOfMonth = String.format("L-%d", this.position);
                        this.definition = Localise.format("%s last day of month at %s", NumberUtils.getOrdinalHybrid(Math.abs(this.position)), this.time.toString());
                    } else {
                        cronDayOfMonth = "L";
                        this.definition = Localise.format("Last day of month at %s", this.time.toString());
                    }
                } else {
                    cronDayOfMonth = "LW";
                    this.definition = Localise.format("Last weekday of month at %s", this.time.toString());
                }
            } else {
                dayOfWeek = this.day.getCronDays().iterator().next();
                cronDayOfWeek = String.format("%sL", dayOfWeek);
                this.definition = Localise.format("last %s of month at %s", this.day.getName(), this.time.toString());
            }
        } else if (this.day == Day.WEEKDAY) {
            cronDayOfMonth = String.format("%dW", this.position);
            this.definition = Localise.format("%s or closest weekday of month at %s", NumberUtils.getOrdinalHybrid(this.position), this.time.toString());
        } else if (this.day.getDays().size() == 1) {
            dayOfWeek = this.day.getCronDays().iterator().next();
            cronDayOfWeek = String.format("%s#%d", dayOfWeek, this.position);
            this.definition = Localise.format("%s %s of month at %s", NumberUtils.getOrdinalHybrid(this.position), this.day.getName(), this.time.toString());
        } else {
            cronDayOfMonth = String.format("%d", this.position);
            this.definition = Localise.format("%s of month at %s", NumberUtils.getOrdinalHybrid(this.position), this.time.toString());
        }
        String cronExpression = String.format("%1$d %2$d %3$d %4$s * %5$s", this.time.getSecond(), this.time.getMinute(), this.time.getHour(), cronDayOfMonth, cronDayOfWeek);
        try {
            this.expression = new CronExpression(cronExpression);
        }
        catch (ParseException e) {
            Localise.logFatal(logger, e, "Unexpected error creating cron expression", new Object[0]);
            Program.exit(1);
        }
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.MONTHLY;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        return this.definition;
    }

    public Day getDay() {
        return this.day;
    }

    public Time getTime() {
        return this.time;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isLast() {
        return this.last;
    }

    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return CronScheduleBuilder.cronSchedule((CronExpression)this.expression).inTimeZone(this.getTimeZone());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.day != Day.DAILY) {
            json.put(JSON_DAY, this.day.toString());
        }
        json.put(JSON_TIME, this.time.toString());
        if (this.position > 1) {
            json.put(JSON_POSITION, this.position);
        }
        if (this.last) {
            json.put(JSON_LAST, true);
        }
        return json;
    }

    @Override
    public MonthlySchedule fromJSON(JSONObject json) {
        super.fromJSON(json);
        try {
            String s = json.optString(JSON_DAY, Day.DAILY.toString()).toUpperCase();
            this.day = s.equals(LAST_DAY) ? Day.DAILY : Day.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_DAY, json.get(JSON_DAY).toString()));
        }
        try {
            this.time = new Time(json.getString(JSON_TIME));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TIME, json.getString(JSON_TIME)));
        }
        this.position = Math.abs(json.optInt(JSON_POSITION, 1));
        if (this.position == 0) {
            this.position = 1;
        }
        this.last = json.optBoolean(JSON_LAST, false);
        if (json.has(JSON_DAY_OF_MONTH)) {
            int dayOfMonth = json.optInt(JSON_DAY_OF_MONTH, 0);
            if (dayOfMonth > 1) {
                this.position = dayOfMonth;
            }
            Localise.logWarn(logger, "converting legacy schedule: %1$d %2$d %3$d %4$s", dayOfMonth, this.position, this.day.toString(), Boolean.toString(this.last));
        }
        try {
            this.init();
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(e.getMessage());
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.MonthlySchedule.Builder builder = ProtoJob.MonthlySchedule.newBuilder();
        builder.setDay(this.day.toProto());
        builder.setTime(this.time.toProto());
        if (this.position != 1) {
            builder.setPosition(this.position);
        }
        if (this.last) {
            builder.setLast(true);
        }
        baseBuilder.setMonthlyExt(builder);
        return baseBuilder;
    }

    @Override
    public MonthlySchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.MonthlySchedule proto = ProtoJob.Schedule.parseFrom(data).getMonthlyExt();
        super.fromProto(data);
        this.day = Day.fromProto(proto.getDay());
        this.time = new Time().fromProto(proto.getTime().toByteArray());
        this.position = Math.abs(proto.getPosition());
        if (this.position == 0) {
            this.position = 1;
        }
        this.last = proto.getLast();
        if (proto.hasDayOfMonth()) {
            int dayOfMonth = proto.getDayOfMonth();
            if (dayOfMonth > 1) {
                this.position = dayOfMonth;
            }
            Localise.logWarn(logger, "converting legacy schedule: %1$d %2$d %3$d %4$s", dayOfMonth, this.position, this.day.toString(), Boolean.toString(this.last));
        }
        this.init();
        return this;
    }
}

