/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.City;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.core.schedule.SolarScheduleBuilder;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.ScheduleBuilder;

public class SolarSchedule
extends Schedule {
    public static final String JSON_CITY = "city";
    public static final String JSON_ZENITH = "zenith";
    public static final String JSON_EVENT = "event";
    public static final String JSON_OFFSET_DIRECTION = "direction";
    public static final String JSON_OFFSET = "offset";
    private Zenith zenith = Zenith.CIVIL;
    private Event event = Event.SUNRISE;
    private boolean offsetBefore = true;
    private Period offset = new Period(0, Period.Unit.SECOND);
    private City city = null;

    protected SolarSchedule() {
    }

    public SolarSchedule(Zenith zenith, Event event, City city) {
        this(null, Job.Action.START, zenith, event, true, new Period(0, Period.Unit.SECOND), city);
    }

    public SolarSchedule(Zenith zenith, Event event, boolean offsetBefore, Period offset, City city) {
        this(null, Job.Action.START, zenith, event, offsetBefore, offset, city);
    }

    public SolarSchedule(Job job, Job.Action action, Zenith zenith, Event event, boolean offsetBefore, Period offset, City city) {
        super(job, action);
        this.zenith = zenith;
        this.event = event;
        this.offsetBefore = offsetBefore;
        this.offset = offset;
        this.city = city;
    }

    public Zenith getZenith() {
        return this.zenith;
    }

    public Event getEvent() {
        return this.event;
    }

    public boolean isOffsetBefore() {
        return this.offsetBefore;
    }

    public Period getOffset() {
        return this.offset;
    }

    public City getCity() {
        return this.city;
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.SOLAR;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        if (this.offset.getValue() != 0) {
            return String.format("%s %s %s %s in %s", this.offset.toString(), this.offsetBefore ? "before" : "after", this.zenith.toString().toLowerCase(), this.event.toString().toLowerCase(), this.city.getId());
        }
        return String.format("%s %s in %s", StringUtils.capitalise(this.zenith.toString()), this.event.toString().toLowerCase(), this.city.getId());
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return SolarScheduleBuilder.solarSchedule(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(JSON_CITY, this.city.getId());
        json.put(JSON_ZENITH, this.zenith.toString());
        json.put(JSON_EVENT, this.event.toString());
        if (!this.offsetBefore) {
            json.put(JSON_OFFSET_DIRECTION, (Object)Direction.AFTER);
        }
        if (this.offset.getValue() != 0) {
            json.put(JSON_OFFSET, this.offset.toString(true));
        }
        return json;
    }

    @Override
    public SolarSchedule fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.city = City.getCityByID(json.getString(JSON_CITY));
        try {
            this.zenith = Zenith.valueOf(json.getString(JSON_ZENITH).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_ZENITH, json.getString(JSON_ZENITH)));
        }
        try {
            this.event = Event.valueOf(json.getString(JSON_EVENT).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_EVENT, json.getString(JSON_EVENT)));
        }
        try {
            this.offsetBefore = Direction.valueOf(json.optString(JSON_OFFSET_DIRECTION, "BEFORE").toUpperCase()) == Direction.BEFORE;
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_EVENT, json.getString(JSON_OFFSET_DIRECTION)));
        }
        if (json.has(JSON_OFFSET)) {
            try {
                this.offset = new Period(json.getString(JSON_OFFSET), Period.Unit.HOUR);
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_OFFSET, json.getString(JSON_OFFSET)));
            }
        } else {
            this.offset = new Period(0, Period.Unit.SECOND);
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.SolarSchedule.Builder builder = ProtoJob.SolarSchedule.newBuilder();
        builder.setCity(this.city.getId());
        if (this.zenith != Zenith.CIVIL) {
            builder.setZenith(this.zenith.toProto());
        }
        if (this.event != Event.SUNRISE) {
            builder.setEvent(this.event.toProto());
        }
        if (!this.offsetBefore) {
            builder.setOffsetBefore(this.offsetBefore);
        }
        if (this.offset.getValue() != 0) {
            builder.setOffset(this.offset.toProto());
        }
        baseBuilder.setSolarExt(builder);
        return baseBuilder;
    }

    @Override
    public SolarSchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.SolarSchedule proto = ProtoJob.Schedule.parseFrom(data).getSolarExt();
        super.fromProto(data);
        this.city = City.getCityByID(proto.getCity());
        this.zenith = Zenith.fromProto(proto.getZenith());
        this.event = Event.fromProto(proto.getEvent());
        this.offsetBefore = proto.getOffsetBefore();
        if (proto.hasOffset()) {
            this.offset.fromProto(proto.getOffset().toByteArray());
        }
        return this;
    }

    public static enum Event {
        SUNRISE,
        SUNSET;

        static EnumMap<Event, ProtoJob.SolarSchedule.Event> eventMap;

        public static Event fromProto(ProtoJob.SolarSchedule.Event event) {
            return eventMap.getA(event);
        }

        public ProtoJob.SolarSchedule.Event toProto() {
            return eventMap.getB(this);
        }

        static {
            eventMap = new EnumMap<Event, ProtoJob.SolarSchedule.Event>(Event.class, ProtoJob.SolarSchedule.Event.class);
        }
    }

    public static enum Zenith {
        ASTRONOMICAL,
        CIVIL,
        NAUTICAL,
        OFFICIAL;

        static EnumMap<Zenith, ProtoJob.SolarSchedule.Zenith> zenithMap;

        public static Zenith fromProto(ProtoJob.SolarSchedule.Zenith zenith) {
            return zenithMap.getA(zenith);
        }

        public ProtoJob.SolarSchedule.Zenith toProto() {
            return zenithMap.getB(this);
        }

        static {
            zenithMap = new EnumMap<Zenith, ProtoJob.SolarSchedule.Zenith>(Zenith.class, ProtoJob.SolarSchedule.Zenith.class);
        }
    }

    private static enum Direction {
        BEFORE,
        AFTER;

    }
}

