/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.City;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.schedule.SolarSchedule;
import com.beyondcron.core.schedule.SolarScheduleBuilder;
import com.luckycatlabs.sunrisesunset.Zenith;
import com.luckycatlabs.sunrisesunset.calculator.SolarEventCalculator;
import com.luckycatlabs.sunrisesunset.dto.Location;
import java.util.Date;
import org.apache.logging.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.AbstractTrigger;

public class SolarTrigger
extends AbstractTrigger {
    private static final Logger logger = LogUtils.getLogger(SolarTrigger.class);
    private SolarSchedule schedule;
    private boolean sunrise;
    private Zenith zenith;
    private long offset;
    private SolarEventCalculator solarCalculator;
    private CalendarInstance calendar = null;
    private Date startTime = new Date();
    private Date endTime = null;
    private Date previousFireTime = null;
    private Date nextFireTime = null;

    public SolarTrigger(SolarSchedule schedule) {
        this.schedule = schedule;
        this.sunrise = schedule.getEvent() == SolarSchedule.Event.SUNRISE;
        switch (schedule.getZenith()) {
            case ASTRONOMICAL: {
                this.zenith = Zenith.ASTRONOMICAL;
                break;
            }
            case CIVIL: {
                this.zenith = Zenith.CIVIL;
                break;
            }
            case NAUTICAL: {
                this.zenith = Zenith.NAUTICAL;
                break;
            }
            case OFFICIAL: {
                this.zenith = Zenith.OFFICIAL;
            }
        }
        Period period = schedule.getOffset();
        this.offset = period.getMilliseconds() * (long)(schedule.isOffsetBefore() ? -1 : 1);
        City city = schedule.getCity();
        Location location = new Location(city.getLatitude(), city.getLongitude());
        this.solarCalculator = new SolarEventCalculator(location, city.getTimeZone());
    }

    public SolarSchedule getSchedule() {
        return this.schedule;
    }

    private void setCalendar(Calendar calendar) {
        try {
            this.calendar = (CalendarInstance)calendar;
        }
        catch (ClassCastException e) {
            this.calendar = null;
            Localise.logError(logger, "Cannot cast %1$s to com.beyondcron.core.calendar.Calendar", calendar.getClass().getName());
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public Date getFinalFireTime() {
        return null;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public Date getFireTimeAfter(Date afterTime) {
        Date timeEnd;
        Date timeStart;
        Date maxTimeEnd = new Date(afterTime.getTime() + 157680000000L);
        Date fireTime = null;
        if (this.calendar != null) {
            timeStart = this.calendar.getNextStartTime(afterTime);
            timeEnd = this.calendar.getNextEndTime(afterTime);
            if (timeStart == null) {
                if (timeEnd == null) {
                    return null;
                }
                timeStart = afterTime;
            } else if (timeEnd.before(timeStart)) {
                timeStart = afterTime;
            }
        } else {
            timeStart = afterTime;
            timeEnd = maxTimeEnd;
        }
        java.util.Calendar time = java.util.Calendar.getInstance(TimeUtils.timeZoneUTC);
        time.setTime(timeStart);
        while (fireTime == null) {
            time = this.sunrise ? this.solarCalculator.computeSunriseCalendar(this.zenith, time) : this.solarCalculator.computeSunsetCalendar(this.zenith, time);
            Date tm = new Date(time.getTimeInMillis() + this.offset);
            if (tm.after(timeStart) && tm.before(timeEnd)) {
                fireTime = tm;
                continue;
            }
            time.add(6, 1);
            time.set(10, 0);
            time.set(12, 0);
            time.set(13, 0);
            tm = time.getTime();
            if (!tm.after(timeEnd)) continue;
            timeStart = this.calendar.getNextStartTime(timeEnd);
            if (timeStart.after(maxTimeEnd)) break;
            timeEnd = this.calendar.getNextEndTime(timeStart);
            time.setTime(timeStart);
        }
        return fireTime;
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        this.triggered(calendar);
        this.previousFireTime = null;
        return this.nextFireTime;
    }

    public void triggered(Calendar calendar) {
        this.setCalendar(calendar);
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.setCalendar(calendar);
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        return misfireInstruction == -1 || misfireInstruction == 0;
    }

    public void updateAfterMisfire(Calendar calender) {
        this.setCalendar(this.calendar);
        this.nextFireTime = this.getFireTimeAfter(new Date());
    }

    public ScheduleBuilder<SolarTrigger> getScheduleBuilder() {
        return SolarScheduleBuilder.solarSchedule(this.schedule);
    }
}

