/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule.cron;

import com.beyondcron.core.Day;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.Time;
import com.beyondcron.core.schedule.CronSchedule;
import com.beyondcron.core.schedule.DailySchedule;
import com.beyondcron.core.schedule.DateSchedule;
import com.beyondcron.core.schedule.MonthlySchedule;
import com.beyondcron.core.schedule.RepeatSchedule;
import com.beyondcron.core.schedule.Schedule;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class ScheduleConverter {
    private static final Logger logger = LogUtils.getLogger(ScheduleConverter.class);
    private static Pattern INCREMENT_SECONDS = Pattern.compile("(\\d+)/(\\d+) [*] [*] [*?] [*] [*?]( [*])?");
    private static Pattern INCREMENT_MINUTES = Pattern.compile("((\\d+)|[*]) (\\d+)/(\\d+) [*] [*?] [*] [*?]( [*])?");
    private static Pattern INCREMENT_HOURS = Pattern.compile("((\\d+)|[*]) ((\\d+)|[*]) (\\d+)/(\\d+) [*?] [*] [*?]( [*])?");
    private static Pattern INCREMENT_MONTHS = Pattern.compile("((\\d+)|[*]) ((\\d+)|[*]) ((\\d+)|[*]) ((\\d+)|[*]) (\\d+)/(\\d+) [*?]( [*])?");
    private static Pattern REPEAT_SECONDS = Pattern.compile("((\\d+)(,\\d+)+) [*] [*] [*?] [*] [*?]( [*])?");
    private static Pattern REPEAT_MINUTES = Pattern.compile("((\\d+)|[*]) ((\\d+)(,\\d+)+) [*] [*?] [*] [*?]( [*])?");
    private static Pattern REPEAT_HOURS = Pattern.compile("((\\d+)|[*]) ((\\d+)|[*]) ((\\d+)(,\\d+)+) [*?] [*] [*?]( [*])?");
    private static Pattern REPEAT_MONTHS = Pattern.compile("((\\d+)|[*]) ((\\d+)|[*]) ((\\d+)|[*]) ((\\d+)|[*]) ((\\d+),(\\d+)+) [*?]( [*])?");
    private static Pattern LAST_DAY_OF_MONTH = Pattern.compile("(\\d+) (\\d+) (\\d+) ([LW]+) [*] [*?]( [*])?");
    private static Pattern LAST_WEEKDAY_OF_MONTH = Pattern.compile("(\\d+) (\\d+) (\\d+) [*?] [*] (SUN|MON|TUE|WED|THU|FRI|SAT)L( [*])?");
    private static Pattern DATE = Pattern.compile("(\\d+) (\\d+) (\\d+) (\\d+) (JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC) [*?]( (\\d+))?");
    private List<Schedule> schedules = new ArrayList<Schedule>();
    private Expression expression;

    public ScheduleConverter(CronSchedule schedule) {
        this.expression = new Expression(schedule.getExpression());
        this.init();
    }

    private void init() {
        if (!(this.isIncrementSchedule() || this.isRepeatSchedule() || this.isDayMonthSchedule() || this.isLastDayOfMonthSchedule() || this.isLastWeekdayOfMonthSchedule())) {
            this.isDateSchedule();
        }
    }

    public boolean canConvert() {
        return !this.schedules.isEmpty();
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    private boolean isDayMonthSchedule() {
        String value;
        Object field2;
        if (this.expression.toString().contains("/")) {
            return false;
        }
        for (Object field2 : Arrays.asList(Expression.Field.SECOND, Expression.Field.MINUTE, Expression.Field.HOUR)) {
            value = this.expression.getField((Expression.Field)((Object)field2));
            if (!value.contains("*")) continue;
            return false;
        }
        value = this.expression.getField(Expression.Field.DAY_OF_MONTH);
        if (value.contains("W") || value.contains("L")) {
            return false;
        }
        value = this.expression.getField(Expression.Field.DAY_OF_WEEK);
        if (value.contains("#") || value.contains("L")) {
            return false;
        }
        if (!this.expression.getField(Expression.Field.MONTH).equals("*") || !this.expression.getField(Expression.Field.YEAR).equals("*")) {
            return false;
        }
        Set<Time> times = this.expression.getTimes();
        field2 = this.expression.getDaysOfMonth().iterator();
        while (field2.hasNext()) {
            int dayOfMonth = (Integer)field2.next();
            for (Time time : times) {
                this.schedules.add(new MonthlySchedule(time, dayOfMonth));
            }
        }
        Set<Day> daysOfWeek = this.expression.getDaysOfWeek();
        if (!daysOfWeek.isEmpty()) {
            for (Time time : times) {
                this.schedules.add(new DailySchedule(time, daysOfWeek));
            }
        }
        return true;
    }

    private boolean isIncrementSchedule() {
        int i;
        String value = this.expression.getValue();
        int second = 0;
        int minute = 0;
        int hour = 0;
        int day = 1;
        Month month = Month.JANUARY;
        int increment = -1;
        Period.Unit unit = null;
        Matcher m = INCREMENT_SECONDS.matcher(value);
        if (m.matches()) {
            unit = Period.Unit.SECOND;
            second = Integer.parseInt(m.group(1));
            i = Integer.parseInt(m.group(2));
            if (60 % i == 0) {
                increment = i;
            }
        }
        if (unit == null && (m = INCREMENT_MINUTES.matcher(value)).matches()) {
            unit = Period.Unit.MINUTE;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = Integer.parseInt(m.group(3));
            i = Integer.parseInt(m.group(4));
            if (60 % i == 0) {
                increment = i;
            }
        }
        if (unit == null && (m = INCREMENT_HOURS.matcher(value)).matches()) {
            unit = Period.Unit.HOUR;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = NumberUtils.parseInt(m.group(3), minute);
            hour = Integer.parseInt(m.group(5));
            i = Integer.parseInt(m.group(6));
            if (24 % i == 0) {
                increment = i;
            }
        }
        if (unit == null && (m = INCREMENT_MONTHS.matcher(value)).matches()) {
            unit = Period.Unit.MONTH;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = NumberUtils.parseInt(m.group(3), minute);
            hour = NumberUtils.parseInt(m.group(5), hour);
            day = NumberUtils.parseInt(m.group(7), day);
            month = Month.of(Integer.parseInt(m.group(9)));
            i = Integer.parseInt(m.group(10));
            if (12 % i == 0) {
                increment = i;
            }
        }
        if (increment > 0) {
            this.schedules.add(this.getRepeatSchedule(second, minute, hour, day, month, unit, increment));
        }
        return unit != null;
    }

    private boolean isRepeatSchedule() {
        int i;
        String value = this.expression.getValue();
        int second = 0;
        int minute = 0;
        int hour = 0;
        int day = 1;
        Month month = Month.JANUARY;
        int increment = -1;
        Period.Unit unit = null;
        Matcher m = REPEAT_SECONDS.matcher(value);
        if (m.matches()) {
            unit = Period.Unit.SECOND;
            second = Integer.parseInt(m.group(2));
            i = this.getIncrement(m.group(1), 60);
            if (i > 0) {
                increment = i;
            }
        }
        if (unit == null && (m = REPEAT_MINUTES.matcher(value)).matches()) {
            unit = Period.Unit.MINUTE;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = Integer.parseInt(m.group(4));
            i = this.getIncrement(m.group(3), 60);
            if (i > 0) {
                increment = i;
            }
        }
        if (unit == null && (m = REPEAT_HOURS.matcher(value)).matches()) {
            unit = Period.Unit.HOUR;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = NumberUtils.parseInt(m.group(3), minute);
            hour = Integer.parseInt(m.group(6));
            i = this.getIncrement(m.group(5), 24);
            if (i > 0) {
                increment = i;
            }
        }
        if (unit == null && (m = REPEAT_MONTHS.matcher(value)).matches()) {
            unit = Period.Unit.MONTH;
            second = NumberUtils.parseInt(m.group(1), second);
            minute = NumberUtils.parseInt(m.group(3), minute);
            hour = NumberUtils.parseInt(m.group(5), hour);
            day = NumberUtils.parseInt(m.group(7), day);
            month = Month.of(Integer.parseInt(m.group(10)));
            i = this.getIncrement(m.group(9), 12);
            if (i > 0) {
                increment = i;
            }
        }
        if (increment > 0) {
            this.schedules.add(this.getRepeatSchedule(second, minute, hour, day, month, unit, increment));
        }
        return unit != null;
    }

    private boolean isLastDayOfMonthSchedule() {
        Matcher m = LAST_DAY_OF_MONTH.matcher(this.expression.getValue());
        if (!m.matches()) {
            return false;
        }
        Day day = m.group(4).contains("W") ? Day.WEEKDAY : Day.DAILY;
        Time time = new Time(Integer.parseInt(m.group(3)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(1)));
        this.schedules.add(new MonthlySchedule(time, day, 1, true));
        return true;
    }

    private boolean isLastWeekdayOfMonthSchedule() {
        Matcher m = LAST_WEEKDAY_OF_MONTH.matcher(this.expression.getValue());
        if (!m.matches()) {
            return false;
        }
        Day day = Day.forName(m.group(4));
        Time time = new Time(Integer.parseInt(m.group(3)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(1)));
        this.schedules.add(new MonthlySchedule(time, day, 1, true));
        return true;
    }

    private boolean isDateSchedule() {
        Month month;
        Matcher m = DATE.matcher(this.expression.getValue());
        if (!m.matches()) {
            return false;
        }
        int hour = Integer.parseInt(m.group(3));
        int minute = Integer.parseInt(m.group(2));
        int second = Integer.parseInt(m.group(1));
        int day = Integer.parseInt(m.group(4));
        switch (m.group(5)) {
            case "JAN": {
                month = Month.JANUARY;
                break;
            }
            case "FEB": {
                month = Month.FEBRUARY;
                break;
            }
            case "MAR": {
                month = Month.MARCH;
                break;
            }
            case "APR": {
                month = Month.APRIL;
                break;
            }
            case "MAY": {
                month = Month.MAY;
                break;
            }
            case "JUN": {
                month = Month.JUNE;
                break;
            }
            case "JUL": {
                month = Month.JULY;
                break;
            }
            case "AUG": {
                month = Month.AUGUST;
                break;
            }
            case "SEP": {
                month = Month.SEPTEMBER;
                break;
            }
            case "OCT": {
                month = Month.OCTOBER;
                break;
            }
            case "NOV": {
                month = Month.NOVEMBER;
                break;
            }
            case "DEC": {
                month = Month.DECEMBER;
                break;
            }
            default: {
                Localise.logError(logger, "Unexpected month - %1$", m.group(5));
                return false;
            }
        }
        int year = NumberUtils.parseInt(m.group(7), 0);
        if (year > 0) {
            this.schedules.add(new DateSchedule(LocalDateTime.of(year, month, day, hour, minute, second)));
        } else {
            this.schedules.add(this.getRepeatSchedule(second, minute, hour, day, month, Period.Unit.YEAR, 1));
        }
        return true;
    }

    private int getIncrement(String value, int size) {
        int first = -1;
        int previous = -1;
        int increment = -1;
        for (String s : value.split(",")) {
            int i = Integer.parseInt(s);
            if (previous >= 0) {
                if (increment > 0) {
                    if (i - previous != increment) {
                        return -1;
                    }
                } else {
                    increment = i - previous;
                }
            } else {
                first = i;
            }
            previous = i;
        }
        if ((previous + increment) % size != first) {
            return -1;
        }
        return increment;
    }

    private RepeatSchedule getRepeatSchedule(int second, int minute, int hour, int day, Month month, Period.Unit unit, int increment) {
        return new RepeatSchedule(new Period(increment, unit), LocalDateTime.of(LocalDateTime.now().getYear(), month, day, hour, minute, second));
    }

    public static class Expression {
        public static final String ANY = "?";
        public static final String ALL = "*";
        public static final String RANGE = "-";
        public static final String INCREMENT = "/";
        public static final String COLLECTION = ",";
        public static final String WEEKDAY = "W";
        public static final String LAST_DAY = "L";
        public static final String NTH_DAY = "#";
        private String value;
        private String[] values;

        public Expression(String value) {
            this.value = value;
            this.values = StringUtils.split(value);
        }

        public String getValue() {
            return this.value;
        }

        public String getField(Field field) {
            int index = field.index;
            return index < this.values.length ? this.values[field.index] : ALL;
        }

        public Set<Time> getTimes() {
            TreeSet<Time> times = new TreeSet<Time>();
            for (int hour : this.getHours()) {
                for (int minute : this.getMinutes()) {
                    for (int second : this.getSeconds()) {
                        times.add(new Time(hour, minute, second));
                    }
                }
            }
            return times;
        }

        public Set<Integer> getHours() {
            return this.getIntegers(this.values[Field.HOUR.index], 0, 23);
        }

        public Set<Integer> getMinutes() {
            return this.getIntegers(this.values[Field.MINUTE.index], 0, 59);
        }

        public Set<Integer> getSeconds() {
            return this.getIntegers(this.values[Field.SECOND.index], 0, 59);
        }

        private Set<Integer> getIntegers(String value, int minValue, int maxValue) {
            TreeSet<Integer> integers = new TreeSet<Integer>();
            for (String s : value.split(COLLECTION)) {
                if (s.contains(INCREMENT)) {
                    throw new NumberFormatException(Localise.format("increments not supported"));
                }
                if (s.equals(ALL)) {
                    for (int i = minValue; i <= maxValue; ++i) {
                        integers.add(i);
                    }
                    continue;
                }
                if (s.equals(ANY)) continue;
                if (s.contains(RANGE)) {
                    String[] a = s.split(RANGE);
                    int start = Integer.parseInt(a[0]);
                    int end = Integer.parseInt(a[1]);
                    for (int i = start; i <= end; ++i) {
                        integers.add(i);
                    }
                    continue;
                }
                integers.add(new Integer(s));
            }
            return integers;
        }

        public Set<Integer> getDaysOfMonth() {
            return this.getIntegers(this.values[Field.DAY_OF_MONTH.index], 1, 31);
        }

        public Set<Day> getDaysOfWeek() {
            HashSet<Day> days = new HashSet<Day>();
            for (String s : this.values[Field.DAY_OF_WEEK.index].split(COLLECTION)) {
                if (s.equals(ALL)) {
                    days.add(Day.DAILY);
                    continue;
                }
                if (s.equals(ANY)) continue;
                if (s.contains(RANGE)) {
                    String[] a = s.split(RANGE);
                    days.addAll(Day.range(Day.forName(a[0]), Day.forName(a[1])));
                    continue;
                }
                days.add(Day.forName(s));
            }
            return Day.consolidateDays(days);
        }

        public String toString() {
            return StringUtils.join(" ", this.values);
        }

        public static enum Field {
            SECOND(0),
            MINUTE(1),
            HOUR(2),
            DAY_OF_MONTH(3),
            MONTH(4),
            DAY_OF_WEEK(5),
            YEAR(6);

            protected int index;

            private Field(int index) {
                this.index = index;
            }
        }
    }
}

