/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.security;

import com.beyondcron.core.JSON;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.proto.ProtoACL;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ACL
implements Comparable<ACL>,
NamedMessage<ACL>,
PersistMessage<ACL>,
JSON<ACL> {
    public static final String MESSAGE_TAG = "acl";
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.security.ACL".hashCode();
    public static final String JSON_NAME = "name";
    public static final String JSON_USER_ROLE = "userRole";
    public static final String JSON_PERMISSIONS = "permissions";
    private static final int PERMISSION_NONE = 0;
    private static final int PERMISSION_READ_VALUE = 1;
    private static final int PERMISSION_EXECUTE_VALUE = 2;
    private static final int PERMISSION_ENABLE_VALUE = 4;
    private static final int PERMISSION_WRITE_VALUE = 8;
    private static final int PERMISSION_ADMIN_VALUE = 16;
    private static final int PERMISSION_ANY = 31;
    private Name name;
    private String userRole;
    private int perms = 0;

    public ACL() {
    }

    public ACL(Name name, String userRole, Permission ... permissions) {
        this.name = name;
        this.userRole = userRole;
        for (Permission permission : permissions) {
            this.perms += permission.getValue();
        }
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Name getPersistName() {
        return Name.parse(this.name, this.userRole);
    }

    public String getUserRole() {
        return this.userRole;
    }

    public Permission[] getPermissions() {
        Permission[] permissions = new Permission[this.perms != 0 ? Integer.bitCount(this.perms) : 1];
        if (this.perms > 0) {
            int i = 0;
            if ((this.perms & 1) != 0) {
                permissions[i++] = Permission.READ;
            }
            if ((this.perms & 2) != 0) {
                permissions[i++] = Permission.EXECUTE;
            }
            if ((this.perms & 4) != 0) {
                permissions[i++] = Permission.ENABLE;
            }
            if ((this.perms & 8) != 0) {
                permissions[i++] = Permission.WRITE;
            }
            if ((this.perms & 0x10) != 0) {
                permissions[i] = Permission.ADMIN;
            }
        } else {
            permissions[0] = Permission.NONE;
        }
        return permissions;
    }

    public String[] getPermissionLabels() {
        switch (this.perms) {
            case 3: {
                return new String[]{Permission.EXECUTE.getLabel() + "+"};
            }
            case 7: {
                return new String[]{Permission.ENABLE.getLabel() + "+"};
            }
            case 15: {
                return new String[]{Permission.WRITE.getLabel() + "+"};
            }
            case 31: {
                return new String[]{Permission.ADMIN.getLabel() + "+"};
            }
        }
        Permission[] permissions = this.getPermissions();
        String[] labels = new String[permissions.length];
        int i = 0;
        for (Permission permission : permissions) {
            labels[i++] = permission.getLabel();
        }
        return labels;
    }

    public ACL addPermission(Permission permission) {
        return this.addPermissions(permission.getValue());
    }

    public ACL addPermissions(int value) {
        this.perms |= value;
        return this;
    }

    public ACL removePermission(Permission permission) {
        int value = permission.getValue();
        if ((this.perms & value) != 0) {
            this.perms ^= value;
        }
        return this;
    }

    public ACL setPermissions(int value) {
        this.perms = value;
        return this;
    }

    public boolean hasPermission(Permission permission) {
        if (permission == Permission.NONE) {
            return this.perms == 0;
        }
        return (this.perms & permission.getValue()) != 0;
    }

    public boolean hasPermission(Permission ... permissions) {
        int i = 0;
        for (Permission permission : permissions) {
            i += permission.getValue();
        }
        return (this.perms & i) != 0;
    }

    public boolean hasPermission(Permission permission, User user) {
        return (this.perms & permission.getValue()) != 0 && (this.userRole.equals(Role.EVERYONE_NAME) || user.hasRole(this.userRole) || user.getName().equals(this.userRole));
    }

    public int getValue() {
        return this.perms;
    }

    public int hashCode() {
        return this.userRole.hashCode() + this.perms;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ACL)) {
            return false;
        }
        return this.compareTo((ACL)obj) == 0;
    }

    @Override
    public int compareTo(ACL that) {
        int i = this.name.compareTo(that.name);
        if (i != 0) {
            return i;
        }
        i = this.userRole.compareTo(that.userRole);
        if (i != 0) {
            return i;
        }
        if (this.perms == that.perms) {
            return 0;
        }
        return this.perms < that.perms ? -1 : 1;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name.toString());
        json.put(JSON_USER_ROLE, this.userRole);
        JSONArray array = new JSONArray();
        for (Permission permission : this.getPermissions()) {
            array.put(permission.toString());
        }
        json.put(JSON_PERMISSIONS, array);
        return json;
    }

    @Override
    public ACL fromJSON(JSONObject json) throws JSONException {
        this.name = Name.parse(json.getString(JSON_NAME));
        this.userRole = json.getString(JSON_USER_ROLE);
        JSONArray array = json.getJSONArray(JSON_PERMISSIONS);
        for (int i = 0; i < array.length(); ++i) {
            this.addPermission(Permission.valueOf(array.getString(i).toUpperCase()));
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    public ProtoACL.ACL.Builder toProto() {
        ProtoACL.ACL.Builder builder = ProtoACL.ACL.newBuilder();
        builder.setName(this.name.toProto());
        builder.setUserRole(this.userRole);
        builder.setPerms(this.perms);
        return builder;
    }

    @Override
    public ACL fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoACL.ACL proto = ProtoACL.ACL.parseFrom(data);
        this.name = new Name(proto.getName());
        this.userRole = proto.getUserRole();
        this.perms = proto.getPerms();
        return this;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name != null ? this.name.toString() : "null");
        l.add(this.userRole != null ? this.userRole : "null");
        for (Permission permission : this.getPermissions()) {
            l.add(permission.toString());
        }
        return StringUtils.join(" ", l);
    }

    public static enum Permission {
        NONE(0, "None"),
        READ(1, "Read"),
        EXECUTE(2, "Execute"),
        ENABLE(4, "Enable"),
        WRITE(8, "Write"),
        ADMIN(16, "Admin"),
        ANY(31, "All");

        private final int value;
        private final String label;

        private Permission(int value, String label) {
            this.value = value;
            this.label = label;
        }

        public int getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

