/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.security;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Pattern;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.proto.ProtoHostACL;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class HostACL
implements Comparable<HostACL>,
Message<HostACL>,
NamedMessage<HostACL>,
PersistMessage<HostACL>,
JSON<HostACL> {
    private static final String MESSAGE_TAG = "acl";
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.security.HostACL".hashCode();
    public static final String JSON_USER_ROLE = "userRole";
    public static final String JSON_USER_GLOB = "userGlob";
    public static final String JSON_USER_REGEX = "userRegex";
    public static final String JSON_HOST_GLOB = "hostGlob";
    public static final String JSON_HOST_REGEX = "hostRegex";
    private static final java.util.regex.Pattern REGEX_USER_HOST = java.util.regex.Pattern.compile("^((((glob|regex):)?([^@ ]+))@)?(((glob|regex):)?([^@ ]+))$");
    private int hashCode;
    private String userRole;
    private Pattern userPattern = null;
    private Pattern hostPattern = null;

    public HostACL() {
    }

    public HostACL(String userRole) {
        this(userRole, userRole, null);
    }

    public HostACL(String userRole, String userHostPattern) {
        this.userRole = userRole;
        Matcher m = REGEX_USER_HOST.matcher(userHostPattern.toLowerCase());
        if (!m.matches()) {
            throw new IllegalArgumentException(Localise.format("invalid user host pattern - %s", userHostPattern));
        }
        if (m.group(2) != null) {
            try {
                this.userPattern = new Pattern(m.group(2));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(Localise.format("invalid user %s - %s", m.group(4), m.group(5)));
            }
        } else {
            this.userPattern = new Pattern();
        }
        if (m.group(8) != null) {
            try {
                this.hostPattern = new Pattern(m.group(6));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(Localise.format("invalid host %s - %s", m.group(8), m.group(9)));
            }
        }
        try {
            this.hostPattern = new Pattern(this.userPattern.getType(), m.group(9));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(Localise.format("invalid host %s - %s", this.userPattern.getType().getLabel(), m.group(9)));
        }
        this.initHashCode();
    }

    public HostACL(String userRole, String userPattern, String hostPattern) {
        this.userRole = userRole;
        this.userPattern = new Pattern(userPattern);
        this.hostPattern = new Pattern(hostPattern);
        this.initHashCode();
    }

    private void initHashCode() {
        this.hashCode = this.toString().hashCode() & 0xFFFFFFF;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public String getPattern() {
        StringBuilder sb = new StringBuilder();
        Pattern.Type userType = this.userPattern.getType();
        if (userType != Pattern.Type.GLOB) {
            sb.append(userType.getLabel()).append(':');
        }
        sb.append(this.userPattern.getPattern());
        sb.append('@');
        Pattern.Type hostType = this.hostPattern.getType();
        if (hostType != userType) {
            sb.append(hostType.getLabel()).append(':');
        }
        sb.append(this.hostPattern.getPattern());
        return sb.toString();
    }

    public String getHostPattern() {
        return this.hostPattern.getPattern();
    }

    public void setHostPattern(String pattern) {
        this.hostPattern = new Pattern(pattern);
        this.initHashCode();
    }

    public String getUserPattern() {
        return this.userPattern.getPattern();
    }

    public void setUserPattern(String pattern) {
        this.userPattern = new Pattern(pattern);
        this.initHashCode();
    }

    public Pattern.Type getHostType() {
        return this.hostPattern.getType();
    }

    public Pattern.Type getUserType() {
        return this.userPattern.getType();
    }

    public boolean matchesAll() {
        return this.userPattern.matchesAll() && this.hostPattern.matchesAll();
    }

    public boolean matches(String userName, String hostName) {
        return this.userPattern.matches(userName) && this.hostPattern.matches(hostName);
    }

    public boolean matchesHostName(String hostName) {
        return this.hostPattern.matches(hostName);
    }

    public boolean matchesUserName(String userName) {
        return this.userPattern.matches(userName);
    }

    @Override
    public Name getName() {
        return Name.parse(BlissUtils.ACL_DIR_HOST_ACLS, this.userRole);
    }

    @Override
    public Name getPersistName() {
        return Name.parse(BlissUtils.ACL_DIR_HOST_ACLS, this.userRole + "." + Integer.toHexString(this.hashCode));
    }

    public String toString() {
        return String.format("%s %s", this.userRole, this.getPattern());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HostACL)) {
            return false;
        }
        return this.compareTo((HostACL)obj) == 0;
    }

    @Override
    public int compareTo(HostACL that) {
        int i = this.userRole.compareTo(that.userRole);
        if (i != 0) {
            return i;
        }
        i = this.hostPattern.compareTo(that.hostPattern);
        if (i != 0) {
            return i;
        }
        return this.userPattern.compareTo(that.userPattern);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_USER_ROLE, this.userRole);
        if (!this.userPattern.matchesAll() && !this.userPattern.matchesAll()) {
            if (this.userPattern.getType() == Pattern.Type.GLOB) {
                json.put(JSON_USER_GLOB, this.userPattern.getPattern());
            } else {
                json.put(JSON_USER_REGEX, this.userPattern.getPattern());
            }
        }
        if (!this.hostPattern.matchesAll()) {
            if (this.hostPattern.getType() == Pattern.Type.GLOB) {
                json.put(JSON_HOST_GLOB, this.hostPattern.getPattern());
            } else {
                json.put(JSON_HOST_REGEX, this.hostPattern.getPattern());
            }
        }
        return json;
    }

    @Override
    public HostACL fromJSON(JSONObject json) throws JSONException {
        this.userRole = json.getString(JSON_USER_ROLE);
        this.hostPattern = json.has(JSON_HOST_GLOB) ? new Pattern(Pattern.Type.GLOB, json.getString(JSON_HOST_GLOB)) : (json.has(JSON_HOST_REGEX) ? new Pattern(Pattern.Type.REGEX, json.getString(JSON_HOST_REGEX)) : new Pattern());
        this.userPattern = json.has(JSON_USER_GLOB) ? new Pattern(Pattern.Type.GLOB, json.getString(JSON_USER_GLOB)) : (json.has(JSON_USER_REGEX) ? new Pattern(Pattern.Type.REGEX, json.getString(JSON_USER_REGEX)) : new Pattern());
        this.initHashCode();
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    public ProtoHostACL.ACL.Builder toProto() {
        ProtoHostACL.ACL.Builder builder = ProtoHostACL.ACL.newBuilder();
        builder.setUserRole(this.userRole);
        if (!this.hostPattern.matchesAll()) {
            builder.setHostPattern(this.hostPattern.toProto());
        }
        if (!this.userPattern.matchesAll()) {
            builder.setUserPattern(this.userPattern.toProto());
        }
        return builder;
    }

    @Override
    public HostACL fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoHostACL.ACL proto = ProtoHostACL.ACL.parseFrom(data);
        this.userRole = proto.getUserRole();
        this.hostPattern = proto.hasHostPattern() ? new Pattern().fromProto(proto.getHostPattern().toByteArray()) : new Pattern();
        this.userPattern = proto.hasUserPattern() ? new Pattern().fromProto(proto.getUserPattern().toByteArray()) : new Pattern();
        this.initHashCode();
        return this;
    }
}

