/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.user;

import com.beyondcron.core.Configs;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class User
implements Cloneable,
Comparable<User>,
JSON<User>,
Message<User> {
    private static SecureRandom random = new SecureRandom();
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String JSON_READ_ONLY = "readOnly";
    public static final String JSON_OS_USER = "osUser";
    public static final String JSON_HOME = "home";
    public static final String JSON_LICENSE = "license";
    public static final String JSON_ROLES = "roles";
    public static final String JSON_PROPERTIES = "properties";
    public static final String PROPERTY_USER_TYPE = "userType";
    public static final String PROPERTY_FIRST_NAME = "firstName";
    public static final String PROPERTY_LAST_NAME = "lastName";
    public static final String PROPERTY_COMPANY = "company";
    public static final String USER_TYPE = "BeyondCron";
    private static final String HOME_FORMAT = (String)Configs.get("beyondcron.user.home");
    public static final String MESSAGE_TAG = "user";
    public static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.user.User".hashCode();
    private String name;
    private String password;
    private long salt;
    private String description;
    private Name home = null;
    private Set<String> roles = new TreeSet<String>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private License license = null;
    private Status status = Status.ENABLED;
    private boolean readOnly = false;
    private boolean osUser = true;

    public User() {
    }

    public User(String name) {
        this(name, "", null);
    }

    public User(String name, String description) {
        this(name, description, null);
    }

    public User(String name, String description, String password) {
        if (name == null) {
            throw new IllegalArgumentException("null user name");
        }
        this.name = name;
        this.setDescription(description);
        this.setPassword(!StringUtils.isNullOrEmpty(password) ? password : User.randomPassword());
        this.home = Name.parse(String.format(HOME_FORMAT, name));
    }

    public User(User user) {
        this.name = user.name;
        this.password = user.password;
        this.salt = user.salt;
        this.description = user.description;
        this.home = user.home;
        this.roles.addAll(user.roles);
        this.properties.putAll(user.properties);
        this.license = user.license;
        this.status = user.status;
        this.readOnly = user.readOnly;
        this.osUser = user.osUser;
    }

    public String getUserType() {
        String type = this.properties.get(PROPERTY_USER_TYPE);
        return type != null ? type : USER_TYPE;
    }

    public boolean isOsUser() {
        return this.osUser;
    }

    public void setOsUser(boolean osUser) {
        this.osUser = osUser;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return StringUtils.join(" ", " ", this.properties.getOrDefault(PROPERTY_FIRST_NAME, ""), this.properties.getOrDefault(PROPERTY_LAST_NAME, ""));
    }

    public boolean validatePassword(String password) {
        return StringUtils.constantEquals(this.password, User.hashPassword(password, this.salt));
    }

    public static String hashPassword(String password, long salt) {
        return StringUtils.hashString(password + salt);
    }

    public boolean hasPassword() {
        return this.password != null && this.password.length() > 0;
    }

    public void setPassword(String password) {
        this.salt = random.nextLong();
        this.password = User.hashPassword(password, this.salt);
    }

    public void setPassword(User user) {
        this.salt = user.salt;
        this.password = user.password;
    }

    public User setHome(Name home) {
        this.home = home;
        return this;
    }

    public Name getHome() {
        return this.home != null ? this.home : Name.ROOT;
    }

    public User addRole(Role role) {
        this.addRole(role.getName());
        return this;
    }

    public User addRole(String role) {
        this.roles.add(role);
        return this;
    }

    public User addRoles(Collection<String> roles) {
        this.roles.addAll(roles);
        return this;
    }

    public User clearRoles() {
        this.roles.clear();
        return this;
    }

    public User removeRole(String name) {
        this.roles.remove(name);
        return this;
    }

    public User removeRoles(Collection<String> roles) {
        this.roles.removeAll(roles);
        return this;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(Role role) {
        return this.hasRole(role.getName());
    }

    public boolean hasRole(String name) {
        return this.roles.contains(name);
    }

    public boolean hasUserRole(String name) {
        return this.name.equals(name) || this.roles.contains(name) || name.equals(Role.EVERYONE_NAME);
    }

    public User setDescription(String description) {
        this.description = description != null ? StringUtils.stripDuplicateSpaces(description) : "";
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public User setProperty(String name, Object value) {
        this.properties.put(name, value != null ? value.toString() : "");
        return this;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean hasLicense() {
        return this.license != null;
    }

    public License getLicense() {
        return this.license;
    }

    public User setLicense(License license) {
        this.license = license;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public User setStatus(Status status) {
        this.status = status;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public User setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public static String randomPassword() {
        return StringUtils.hashString(Long.toString(random.nextLong()));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includePassword) {
        return this.toTable(includePassword).toString();
    }

    protected TableFormatter toTable(boolean includePassword) {
        TableFormatter table = new TableFormatter();
        TableFormatter cell = new TableFormatter();
        table.addRow("Name", this.name);
        table.addRow("Description", this.description);
        if (includePassword) {
            table.addRow("Password", includePassword);
            table.addRow("Salt", this.salt);
        }
        table.addRow("Roles", StringUtils.join("\n", this.roles));
        for (String name : this.properties.keySet()) {
            cell.addRow(name, this.properties.get(name));
        }
        table.startRow().addValue("Properties").addValue((Object)cell, false).endRow();
        table.addRow("ReadOnly", this.isReadOnly());
        table.startRow().addValue("License").addValue(this.license != null ? this.license.toTable() : "", false).endRow();
        table.addRow("Status", this.status.toString().toLowerCase());
        return table;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        if (this.readOnly) {
            json.put(JSON_READ_ONLY, this.readOnly);
        }
        if (!this.osUser) {
            json.put(JSON_OS_USER, this.osUser);
        }
        if (!this.properties.isEmpty()) {
            json.put(JSON_PROPERTIES, new JSONObject(this.properties));
        }
        if (!StringUtils.isNullOrEmpty(this.home)) {
            json.put(JSON_HOME, this.home.toString());
        }
        if (this.license != null) {
            json.put(JSON_LICENSE, this.license.toJSON());
        }
        json.put(JSON_ROLES, new JSONArray(this.roles));
        return json;
    }

    @Override
    public User fromJSON(JSONObject json) {
        this.name = json.getString(JSON_NAME);
        this.password = User.randomPassword();
        this.description = json.optString(JSON_DESCRIPTION);
        this.readOnly = json.optBoolean(JSON_READ_ONLY);
        this.osUser = json.optBoolean(JSON_OS_USER, true);
        this.properties.clear();
        if (json.has(JSON_PROPERTIES)) {
            JSONObject p = json.getJSONObject(JSON_PROPERTIES);
            for (String key : JSONObject.getNames(p)) {
                this.properties.put(key, p.getString(key));
            }
        }
        if (json.has(JSON_HOME)) {
            try {
                this.home = new Name(json.getString(JSON_HOME));
            }
            catch (URISyntaxException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_HOME, json.get(JSON_HOME).toString(), e.getMessage()));
            }
        } else {
            this.home = null;
        }
        this.license = json.has(JSON_LICENSE) ? new License().fromJSON(json.getJSONObject(JSON_LICENSE)) : null;
        this.roles.clear();
        JSONArray a = json.getJSONArray(JSON_ROLES);
        for (int i = 0; i < a.length(); ++i) {
            this.roles.add(a.getString(i));
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    public ProtoUser.User.Builder toProto() {
        return this.toProto(false);
    }

    public ProtoUser.User.Builder toProto(boolean excludePassword) {
        ProtoUser.User.Builder builder = ProtoUser.User.newBuilder();
        builder.setName(this.name);
        if (!excludePassword) {
            builder.setPassword(this.password);
            builder.setSalt(this.salt);
        }
        if (this.description != null && this.description.length() > 0) {
            builder.setDescription(this.description);
        }
        if (this.readOnly) {
            builder.setReadOnly(true);
        }
        if (!this.osUser) {
            builder.setOsUser(this.osUser);
        }
        if (this.home != null) {
            builder.setHome(this.home.toProto());
        }
        builder.addAllRoles(this.roles);
        for (String name : this.properties.keySet()) {
            builder.addProperties(ProtoProperty.Property.newBuilder().setName(name).setValue(this.properties.get(name)));
        }
        if (this.license != null) {
            builder.setLicense(this.license.toProto());
        }
        if (this.status != Status.ENABLED) {
            builder.setStatus(this.status.toProto());
        }
        return builder;
    }

    @Override
    public User fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.User proto = ProtoUser.User.parseFrom(data);
        this.name = proto.getName();
        this.password = proto.hasPassword() ? proto.getPassword() : "";
        this.salt = proto.hasSalt() ? proto.getSalt() : 0L;
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.readOnly = proto.getReadOnly();
        this.osUser = proto.getOsUser();
        this.home = proto.hasHome() ? new Name().fromProto(proto.getHome().toByteArray()) : null;
        this.roles.clear();
        if (proto.getRolesCount() > 0) {
            this.roles.addAll((Collection<String>)proto.getRolesList());
        }
        this.properties.clear();
        for (ProtoProperty.Property property : proto.getPropertiesList()) {
            this.properties.put(property.getName(), property.getValue());
        }
        this.license = proto.hasLicense() ? new License().fromProto(proto.getLicense().toByteArray()) : null;
        this.status = proto.hasStatus() ? Status.fromProto(proto.getStatus()) : Status.ENABLED;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        return this.compareTo((User)obj) == 0;
    }

    @Override
    public int compareTo(User that) {
        return this.name.compareTo(that.name);
    }

    public static enum Status {
        ENABLED,
        DISABLED,
        UNVERIFIED,
        EXPIRED;

        public static EnumMap<Status, ProtoUser.User.Status> statusMap;

        public static Status fromProto(ProtoUser.User.Status status) {
            return statusMap.getA(status);
        }

        public ProtoUser.User.Status toProto() {
            return statusMap.getB(this);
        }

        static {
            statusMap = new EnumMap<Status, ProtoUser.User.Status>(Status.class, ProtoUser.User.Status.class);
        }
    }
}

