/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.Configs;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Result;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.UserACLValidator;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.ConnectionException;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.ConnectionAuthenticate;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.UserQuery;
import com.beyondcron.messaging.message.UserRefresh;
import com.hazelcast.core.IQueue;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class CommandConnection
extends Connection {
    private static final Logger logger = LogUtils.getLogger(CommandConnection.class);
    private long lockPeriod = 0L;
    private long closePeriod = 0L;
    private long lockDelay = 0L;
    private long closeDelay = 0L;
    static int POLL_TIMEOUT = 10;
    static TimeUnit POLL_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private String clientId = this.hazelcast.getLocalEndpoint().getUuid();
    private IQueue<CommandMessage> sendQueue = Hazelcast.getCommandSendQueue(this.hazelcast);
    private IQueue<ResultMessage> receiveQueue = Hazelcast.getCommandReceiveQueue(this.hazelcast);
    private UserACLValidator aclValidator = UserACLValidator.getInstance(this.hazelcast, this.getUser());
    private boolean locked = false;
    private static Timer idleTimer = new Timer();
    private TimerTask idleTimerTask = null;

    public CommandConnection(String userName, String userPassword, Connection.Type type, Collection<InetSocketAddress> servers) throws ConnectionException {
        this(userName, userPassword, type, servers, null);
    }

    public CommandConnection(String userName, String userPassword, Connection.Type type, Collection<InetSocketAddress> servers, InetSocketAddress clientAddress) throws ConnectionException {
        super(userName, userPassword, type, servers, clientAddress);
        this.setInactiveClosePeriod(((Period)Configs.get("beyondcron.connection.close")).getMilliseconds());
        this.setInactiveLockPeriod(((Period)Configs.get("beyondcron.connection.lock")).getMilliseconds());
        Localise.logInfo(logger, "Connected to %1$s cluster", this.getClusterName());
    }

    @Override
    public void close() {
        this.locked = true;
        this.cancelIdleTimer();
        if (this.connectionListener != null) {
            this.connectionListener.closed(null);
        }
        if (this.isConnected() && this.receiveQueue != null) {
            this.receiveQueue.destroy();
            this.receiveQueue = null;
        }
        super.close();
    }

    public long getInactiveLockPeriod() {
        return this.lockPeriod;
    }

    public void setInactiveLockPeriod(long milliseconds) {
        this.lockPeriod = milliseconds;
        this.setInactiveDelays();
        this.resetIdleTimer();
    }

    public long getInactiveClosePeriod() {
        return this.closePeriod;
    }

    public void setInactiveClosePeriod(long milliseconds) {
        this.closePeriod = milliseconds;
        this.setInactiveDelays();
        this.resetIdleTimer();
    }

    private void setInactiveDelays() {
        if (this.lockPeriod > 0L && this.closePeriod > 0L) {
            if (this.lockPeriod < this.closePeriod) {
                this.lockDelay = this.lockPeriod;
                this.closeDelay = this.closePeriod - this.lockPeriod;
            } else {
                this.lockDelay = 0L;
                this.closeDelay = this.closePeriod;
            }
        } else {
            this.lockDelay = this.lockPeriod > 0L ? this.lockPeriod : 0L;
            this.closeDelay = this.closePeriod > 0L ? this.closePeriod : 0L;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean authenticate(String password) {
        this.receiveQueue.clear();
        ResultMessage result = this.send(new ConnectionAuthenticate(password)).receive();
        if (!result.getResult().wasSuccess()) {
            return false;
        }
        this.locked = false;
        this.resetIdleTimer();
        return true;
    }

    public boolean heartbeat() {
        if (!this.locked) {
            this.resetIdleTimer();
        }
        return !this.locked;
    }

    public User refreshUser() {
        ResultMessage response = this.sendReceive(new UserRefresh());
        if (!response.getResult().wasSuccess()) {
            logger.error(response.getResult().getMessage());
        }
        User user = ((UserRefresh.Response)response).getUser();
        if (this.aclValidator != null) {
            this.aclValidator.refreshUser(user);
        }
        return user;
    }

    public User getUser() {
        if (this.aclValidator != null) {
            return this.aclValidator.getUser();
        }
        ResultMessage response = this.sendReceive(new UserQuery(this.getUserName()));
        if (!response.getResult().wasSuccess()) {
            logger.error(response.getResult().getMessage());
            return null;
        }
        return ((UserQuery.Response)response).getUser();
    }

    private CommandConnection send(CommandMessage message) {
        message.setClientId(this.clientId);
        this.sendQueue.add((Object)message);
        return this;
    }

    private ResultMessage receive() {
        ResultMessage response;
        try {
            response = (ResultMessage)this.receiveQueue.poll((long)POLL_TIMEOUT, POLL_TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            String msg = Localise.format("Unexpectedly interrupted");
            logger.warn(msg);
            response = new Result(false, msg, new Link[0]);
        }
        catch (Exception e) {
            response = new Result(e);
        }
        if (response == null) {
            response = new Result(false, Localise.format("Timed out waiting for message"), new Link[0]);
        }
        return response;
    }

    public ResultMessage sendReceive(CommandMessage message) {
        return this.sendReceive(message, false);
    }

    public synchronized ResultMessage sendReceive(CommandMessage message, boolean ignoreLock) {
        ResultMessage result;
        if (logger.isDebugEnabled()) {
            Localise.logDebug(logger, "Sending %s", message.getClass().getName());
        }
        this.receiveQueue.clear();
        if (ignoreLock) {
            result = this.send(message).receive();
        } else {
            if (this.locked) {
                if (this.isConnected()) {
                    return new Result(false, Localise.format("Connection locked due to inactivity"), new Link[0]);
                }
                return new Result(false, Localise.format("Connection closed due to inactivity"), new Link[0]);
            }
            this.cancelIdleTimer();
            result = this.send(message).receive();
            this.startIdleTimer();
        }
        if (logger.isDebugEnabled()) {
            Localise.logDebug(logger, "Received %1$s", result.getClass().getName());
        }
        return result;
    }

    public boolean hasACL(Name name) {
        return this.aclValidator.hasACLs(name);
    }

    public boolean hasPermission(Name name, ACL.Permission permission) {
        return this.aclValidator.hasPermission(name, permission);
    }

    public boolean hasPermission(Name name, ACL.Permission ... permissions) {
        return this.aclValidator.hasPermission(name, permissions);
    }

    public boolean isAdmin() {
        return this.aclValidator.isAdmin();
    }

    public boolean isAdminUser() {
        return this.aclValidator.isAdminUser();
    }

    public UserACLValidator getACLValidator() {
        return this.aclValidator;
    }

    private void startIdleTimer() {
        if (this.lockDelay > 0L) {
            this.startIdleTimer(new LockTask(), this.lockDelay);
        } else if (this.closeDelay > 0L) {
            this.startIdleTimer(new CloseTask(), this.closeDelay);
        }
    }

    private void startIdleTimer(TimerTask task, long delay) {
        this.cancelIdleTimer();
        try {
            idleTimer.schedule(task, delay);
        }
        catch (IllegalStateException ex) {
            Localise.logWarn(logger, "Timer canceled, recreating", new Object[0]);
            idleTimer = new Timer();
            idleTimer.schedule(task, delay);
        }
        this.idleTimerTask = task;
    }

    private void cancelIdleTimer() {
        if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
            this.idleTimerTask = null;
        }
    }

    private void resetIdleTimer() {
        this.cancelIdleTimer();
        this.startIdleTimer();
    }

    public static void shutdown() {
        idleTimer.cancel();
    }

    private class CloseTask
    extends TimerTask {
        private CloseTask() {
        }

        @Override
        public void run() {
            Connection.ConnectionListener listener = CommandConnection.this.connectionListener;
            CommandConnection.this.connectionListener = null;
            CommandConnection.this.close();
            if (listener != null) {
                listener.closed(Localise.format("Closed due to inactivity."));
            }
        }
    }

    private class LockTask
    extends TimerTask {
        private LockTask() {
        }

        @Override
        public void run() {
            CommandConnection.this.locked = true;
            if (CommandConnection.this.connectionListener != null) {
                CommandConnection.this.connectionListener.locked(Localise.format("Locked due to inactivity."));
            }
            if (CommandConnection.this.closeDelay > 0L) {
                CommandConnection.this.startIdleTimer(new CloseTask(), CommandConnection.this.closeDelay);
            }
        }
    }
}

