/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.Configs;
import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Property;
import com.beyondcron.core.Role;
import com.beyondcron.core.Service;
import com.beyondcron.core.ServiceStatus;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.calendar.ICalendarInstance;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobMode;
import com.beyondcron.core.job.QueuedJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.message.Announcement;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionRegister;
import com.beyondcron.messaging.message.JobExecute;
import com.beyondcron.messaging.message.PersistUpdate;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Hazelcast {
    static final Logger logger = LogUtils.getLogger(Hazelcast.class);
    public static final String DEFAULT_HOST = Hazelcast.getDefaultAddress();
    public static final int DEFAULT_PORT = (Integer)Configs.get("BEYONDCRON_SERVER_PORT");
    public static final String ACL_MAP = "acls";
    public static final String ACL_GROUP_MAP = "acl.groups";
    public static final String ACL_TRIGGER_PERMISSION_MAP = "acl.trigger.permission";
    public static final String ACL_HOST_MAP = "acl.hosts";
    public static final String AGENT_MAP = "agents";
    public static final String AGENT_SSH_SET = "agents.ssh";
    public static final String AGENT_COMMAND_QUEUE_FORMAT = "agent.command.%s";
    public static final String AGENT_SSH_COMMAND_QUEUE = "agent.command.ssh";
    public static final String ANNOUNCEMENT_TOPIC = "announcements";
    public static final String CALENDAR_MAP = "calendars";
    public static final String CALENDAR_GROUP_MAP = "calendar.groups";
    public static final String CALENDAR_INSTANCE_MAP = "calendar.instances";
    public static final String CALENDAR_JOB_MAP = "calendar.jobs";
    public static final String ICALENDAR_MAP = "icalendars";
    public static final String ICALENDAR_INSTANCE_MAP = "icalendar.instances";
    public static final String ICALENDAR_CALENDAR_MAP = "icalendar.calendar";
    public static final String COMMAND_SEND_QUEUE = "command.queue";
    public static final String COMMAND_RECEIVE_QUEUE_FORMAT = "command.response.%s";
    public static final String CONFIG_MAP = "configs";
    public static final String CONNECTION_MAP = "connections";
    public static final String CONNECTION_SEND_QUEUE = "connection.queue";
    public static final String CONNECTION_RECEIVE_QUEUE_FORMAT = "connection.response.%s";
    public static final String GROUP_TREE_MAP = "group.tree";
    public static final String JOB_MAP = "jobs";
    public static final String JOB_MODE_MAP = "job.modes";
    public static final String JOB_MODE_UPDATE_TOPIC = "job.mode.updates";
    public static final String JOB_GROUP_MAP = "job.groups";
    public static final String JOB_LISTENER_MAP = "job.listeners";
    public static final String JOB_LISTENER_WILDCARD_MAP = "job.listeners.wildcards";
    public static final String JOB_STATUS_MAP = "job.statuses";
    public static final String JOB_ACTIVE_MAP = "job.active";
    public static final String JOB_STATUS_QUEUE = "job.status";
    public static final String JOB_AGENT_MAP = "job.agent";
    public static final String LICENSE_MAP = "licenses";
    public static final String LICENSE_LIMITS = "license.limits";
    public static final String LICENSE_OWNERS = "license.owners";
    public static final String LICENSE_LIMITS_SERVER_CALENDARS = "license.limits.server.calendars";
    public static final String LICENSE_LIMITS_SERVER_JOBS = "license.limits.server.jobs";
    public static final String LICENSE_LIMITS_SERVER_EXECUTIONS = "license.limits.server.executions";
    public static final String LIMITS_EXPIRED = "limits.expired";
    public static final String LIMITS_LOG_EPOCH = "limits.log.epoch";
    public static final String LIMITS_LOG_EPOCH_EXECUTIONS = "limits.log.epoch.executions";
    public static final String LIMITS_LOG_EPOCH_LOCK = "limits.log.epoch.lock";
    public static final String PARTITION_JOB_MAP = "partition.jobs";
    public static final String PERSIST_MEMBER_NAME_MAP = "persist.member.name";
    public static final String PERSIST_MEMBER_REPOSITORY_MAP = "persist.member.repository";
    public static final String PERSIST_MEMBERS_LOCK = "persist.members.lock";
    public static final String PERSIST_UPDATES_TOPIC = "persist.updates";
    public static final String PROPERTY_MAP = "properties";
    public static final String PROPERTY_GROUP_MAP = "property.groups";
    public static final String PROTECTED_NAME_MAP = "protected.names";
    public static final String QUEUED_JOBS_QUEUE = "queued.jobs";
    public static final String ROLE_MAP = "roles";
    public static final String USER_MAP = "users";
    public static final String USER_HOMES = "user.homes";
    public static final String USER_CACHE = "user.cache";
    public static final String SERVER_JOBS = "server.jobs";
    public static final String SERVER_MAP = "servers";
    public static final String SERVICE_STATUS_MAP = "service.statuses";

    public static String getDefaultAddress() {
        InetAddress localAddress;
        String[] filters;
        boolean ip6Address;
        boolean privateAddress;
        InetAddress defaultAddress;
        block13: {
            defaultAddress = null;
            privateAddress = (Boolean)Configs.get("BEYONDCRON_SERVER_ADDRESS_PRIVATE");
            ip6Address = (Boolean)Configs.get("BEYONDCRON_SERVER_ADDRESS_IPV6");
            filters = StringUtils.split((String)Configs.get("BEYONDCRON_SERVER_ADDRESS_IGNORE"));
            try {
                localAddress = InetAddress.getLocalHost();
                if (localAddress.isLoopbackAddress() || !Hazelcast.isPreferredAddress(localAddress, ip6Address, privateAddress)) break block13;
                defaultAddress = localAddress;
                String s = defaultAddress.getHostAddress();
                for (String filter : filters) {
                    if (!s.startsWith(filter)) continue;
                    defaultAddress = null;
                    break;
                }
            }
            catch (UnknownHostException e) {
                Localise.logError(logger, e, "Could not get host name", new Object[0]);
                localAddress = InetAddress.getLoopbackAddress();
            }
        }
        if (defaultAddress == null) {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (InetAddress address : NetUtils.getLocalAddresses()) {
                boolean ignore = false;
                String s = address.getHostAddress();
                for (String filter : filters) {
                    if (!s.startsWith(filter)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                addresses.add(address);
            }
            if (privateAddress) {
                for (InetAddress address : addresses) {
                    if (!address.isSiteLocalAddress() || address.isLoopbackAddress()) continue;
                    defaultAddress = address;
                    if (!Hazelcast.isPreferredAddress(address, ip6Address)) continue;
                    break;
                }
                if (defaultAddress != null && !Hazelcast.isPreferredAddress(defaultAddress, ip6Address) && !localAddress.isLoopbackAddress() && localAddress.isSiteLocalAddress()) {
                    defaultAddress = localAddress;
                }
            } else {
                for (InetAddress address : addresses) {
                    if (address.isSiteLocalAddress() || address.isLoopbackAddress()) continue;
                    defaultAddress = address;
                    if (!Hazelcast.isPreferredAddress(address, ip6Address)) continue;
                    break;
                }
                if (!(defaultAddress == null || Hazelcast.isPreferredAddress(defaultAddress, ip6Address) || localAddress.isLoopbackAddress() || localAddress.isSiteLocalAddress())) {
                    defaultAddress = localAddress;
                }
            }
            if (defaultAddress == null) {
                defaultAddress = localAddress;
                Localise.logError(logger, "Could not get host name, using loopback address", new Object[0]);
            }
        }
        return defaultAddress.getHostAddress();
    }

    public static boolean isPreferredAddress(InetAddress address, boolean ip6Address) {
        if (address instanceof Inet6Address) {
            return ip6Address;
        }
        return !ip6Address;
    }

    public static boolean isPreferredAddress(InetAddress address, boolean ip6Address, boolean privateAddress) {
        if (address.isSiteLocalAddress() != privateAddress) {
            return false;
        }
        return Hazelcast.isPreferredAddress(address, ip6Address);
    }

    public static MultiMap<Name, ACL> getACLMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(ACL_MAP);
    }

    public static MultiMap<Name, Name> getACLGroupMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(ACL_GROUP_MAP);
    }

    public static IMap<String, Boolean> getACLTriggerPermissionMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(ACL_TRIGGER_PERMISSION_MAP);
    }

    public static MultiMap<String, HostACL> getACLHostMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(ACL_HOST_MAP);
    }

    public static IMap<String, Connection> getAgentMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(AGENT_MAP);
    }

    public static ISet<String> getAgentSshSet(HazelcastInstance hazelcast) {
        return hazelcast.getSet(AGENT_SSH_SET);
    }

    public static IQueue<JobExecute> getAgentCommandQueue(HazelcastInstance hazelcast, String hostName) {
        return hazelcast.getQueue(Hazelcast.getAgentCommandQueueName(hostName));
    }

    public static String getAgentCommandQueueName(String hostName) {
        return String.format(AGENT_COMMAND_QUEUE_FORMAT, hostName);
    }

    public static IQueue<JobExecute> getAgentSshCommandQueue(HazelcastInstance hazelcast) {
        return hazelcast.getQueue(AGENT_SSH_COMMAND_QUEUE);
    }

    public static ITopic<Announcement> getAnnouncementTopic(HazelcastInstance hazelcast) {
        return hazelcast.getTopic(ANNOUNCEMENT_TOPIC);
    }

    public static IMap<Name, Calendar> getCalendarMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(CALENDAR_MAP);
    }

    public static MultiMap<Name, CalendarInstance> getCalendarInstanceMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(CALENDAR_INSTANCE_MAP);
    }

    public static MultiMap<Name, Name> getCalendarJobMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(CALENDAR_JOB_MAP);
    }

    public static MultiMap<Name, Name> getCalendarGroupMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(CALENDAR_GROUP_MAP);
    }

    public static IMap<URI, ICalendarData> getICalendarMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(ICALENDAR_MAP);
    }

    public static MultiMap<URI, ICalendarInstance> getICalendarInstanceMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(ICALENDAR_INSTANCE_MAP);
    }

    public static MultiMap<URI, Name> getICalendarCalendarMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(ICALENDAR_CALENDAR_MAP);
    }

    public static IQueue<CommandMessage> getCommandSendQueue(HazelcastInstance hazelcast) {
        return hazelcast.getQueue(COMMAND_SEND_QUEUE);
    }

    public static IQueue<ResultMessage> getCommandReceiveQueue(HazelcastInstance hazelcast) {
        return Hazelcast.getCommandReceiveQueue(hazelcast, hazelcast.getLocalEndpoint().getUuid());
    }

    public static IQueue<ResultMessage> getCommandReceiveQueue(HazelcastInstance hazelcast, String clientId) {
        return hazelcast.getQueue(Hazelcast.getCommandReceiveQueueName(clientId));
    }

    public static String getCommandReceiveQueueName(String clientId) {
        return String.format(COMMAND_RECEIVE_QUEUE_FORMAT, clientId);
    }

    public static IMap<String, Config> getConfigMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(CONFIG_MAP);
    }

    public static IMap<String, Connection> getConnectionMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(CONNECTION_MAP);
    }

    public static IQueue<ConnectionRegister> getConnectionSendQueue(HazelcastInstance hazelcast) {
        return hazelcast.getQueue(CONNECTION_SEND_QUEUE);
    }

    public static IQueue<ConnectionRegister.Response> getConnectionReceiveQueue(HazelcastInstance hazelcast) {
        return Hazelcast.getConnectionReceiveQueue(hazelcast, hazelcast.getLocalEndpoint().getUuid());
    }

    public static IQueue<ConnectionRegister.Response> getConnectionReceiveQueue(HazelcastInstance hazelcast, String clientId) {
        return hazelcast.getQueue(String.format(CONNECTION_RECEIVE_QUEUE_FORMAT, clientId));
    }

    public static MultiMap<Name, Name> getGroupTreeMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(GROUP_TREE_MAP);
    }

    public static IMap<Name, Job> getJobMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(JOB_MAP);
    }

    public static IMap<Name, JobMode> getJobModeMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(JOB_MODE_MAP);
    }

    public static ITopic<Name> getJobModeUpdateTopic(HazelcastInstance hazelcast) {
        return hazelcast.getTopic(JOB_MODE_UPDATE_TOPIC);
    }

    public static MultiMap<Name, Name> getJobGroupMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(JOB_GROUP_MAP);
    }

    public static MultiMap<Name, Name> getJobListenerMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(JOB_LISTENER_MAP);
    }

    public static MultiMap<Name, Name> getJobListenerWildcardMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(JOB_LISTENER_WILDCARD_MAP);
    }

    public static IMap<Name, Status> getJobStatusMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(JOB_STATUS_MAP);
    }

    public static IMap<Name, Long> getJobActiveMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(JOB_ACTIVE_MAP);
    }

    public static IQueue<Status> getJobStatusQueue(HazelcastInstance hazelcast) {
        return hazelcast.getQueue(JOB_STATUS_QUEUE);
    }

    public static IMap<Name, String> getJobAgentMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(JOB_AGENT_MAP);
    }

    public static IMap<String, License> getLicences(HazelcastInstance hazelcast) {
        return hazelcast.getMap(LICENSE_MAP);
    }

    public static IMap<String, Limit> getLicenseLimits(HazelcastInstance hazelcast) {
        return hazelcast.getMap(LICENSE_LIMITS);
    }

    public static IAtomicLong getLicenseLimitsServerCalendars(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LICENSE_LIMITS_SERVER_CALENDARS);
    }

    public static IAtomicLong getLicenseLimitsServerJobs(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LICENSE_LIMITS_SERVER_JOBS);
    }

    public static IAtomicLong getLicenseLimitsServerExecutions(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LICENSE_LIMITS_SERVER_EXECUTIONS);
    }

    public static IMap<Name, String> getLicenseOwners(HazelcastInstance hazelcast) {
        return hazelcast.getMap(LICENSE_OWNERS);
    }

    public static IAtomicLong getLimitsExpired(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LIMITS_EXPIRED);
    }

    public static IAtomicLong getLimitsLogEpoch(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LIMITS_LOG_EPOCH);
    }

    public static IAtomicLong getLimitsLogEpochExecutions(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(LIMITS_LOG_EPOCH_EXECUTIONS);
    }

    public static ILock getLimitsLogEpochLock(HazelcastInstance hazelcast) {
        return hazelcast.getLock(LIMITS_LOG_EPOCH_LOCK);
    }

    public static MultiMap<Integer, Name> getPartitionJobMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(PARTITION_JOB_MAP);
    }

    public static IMap<InetSocketAddress, String> getPersistMemberNameMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(PERSIST_MEMBER_NAME_MAP);
    }

    public static IMap<String, String> getPersistMemberRepositoryMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(PERSIST_MEMBER_REPOSITORY_MAP);
    }

    public static ILock getPersistMembersLock(HazelcastInstance hazelcast) {
        return hazelcast.getLock(PERSIST_MEMBERS_LOCK);
    }

    public static ITopic<PersistUpdate> getPersistUpdatesTopic(HazelcastInstance hazelcast) {
        return hazelcast.getTopic(PERSIST_UPDATES_TOPIC);
    }

    public static MultiMap<Name, Property> getPropertyMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(PROPERTY_MAP);
    }

    public static MultiMap<Name, Name> getPropertyGroupMap(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(PROPERTY_GROUP_MAP);
    }

    public static MultiMap<Protected.Type, String> getProtectedNames(HazelcastInstance hazelcast) {
        return hazelcast.getMultiMap(PROTECTED_NAME_MAP);
    }

    public static String getQueuedJobsQueueName(Name name) {
        return QUEUED_JOBS_QUEUE + name.toString().replace('/', '.');
    }

    public static IQueue<QueuedJob> getQueuedJobsQueue(HazelcastInstance hazelcast, Name name) {
        return hazelcast.getQueue(Hazelcast.getQueuedJobsQueueName(name));
    }

    public static IMap<String, Role> getRoleMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(ROLE_MAP);
    }

    public static IMap<String, User> getUserMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(USER_MAP);
    }

    public static IMap<Name, String> getUserHomes(HazelcastInstance hazelcast) {
        return hazelcast.getMap(USER_HOMES);
    }

    public static IMap<String, String> getUserCache(HazelcastInstance hazelcast) {
        return hazelcast.getMap(USER_CACHE);
    }

    public static IAtomicLong getServerJobs(HazelcastInstance hazelcast) {
        return hazelcast.getAtomicLong(SERVER_JOBS);
    }

    public static IMap<String, Connection> getServerMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(SERVER_MAP);
    }

    public static IMap<Service.Type, ServiceStatus> getServiceStatusMap(HazelcastInstance hazelcast) {
        return hazelcast.getMap(SERVICE_STATUS_MAP);
    }

    public static <V> List<V> getValues(MultiMap<Name, Name> tree, MultiMap<Name, Name> groups, IMap<Name, V> map, Name name) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object value = map.get((Object)name);
        if (value != null) {
            values.add(value);
        }
        for (Name n : groups.get((Object)name)) {
            values.add(map.get((Object)n));
        }
        if (tree.containsKey((Object)name)) {
            for (Name g : tree.get((Object)name)) {
                values.addAll(Hazelcast.getValues(tree, groups, map, g));
            }
        }
        return values;
    }

    public static <V> List<V> getValues(MultiMap<Name, V> map, Name name) {
        ArrayList values = new ArrayList();
        for (Name n : map.keySet()) {
            if (!name.equals(n) && !name.contains(n)) continue;
            values.addAll(map.get((Object)n));
        }
        return values;
    }

    public static DistributedObject getObject(HazelcastInstance hazelcast, String name) {
        for (DistributedObject obj : hazelcast.getDistributedObjects()) {
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        return null;
    }

    public static abstract class AbstractEntryListener<K, V>
    implements EntryListener<K, V> {
        protected Logger logger;
        protected Level level = Level.DEBUG;

        public AbstractEntryListener(Logger logger) {
            this.logger = logger;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public void entryAdded(EntryEvent<K, V> event) {
            this.logEvent(event);
        }

        public void entryRemoved(EntryEvent<K, V> event) {
            this.logEvent(event);
        }

        public void entryUpdated(EntryEvent<K, V> event) {
            this.logEvent(event);
        }

        public void entryEvicted(EntryEvent<K, V> event) {
            this.logEvent(event);
        }

        public void mapEvicted(MapEvent event) {
            this.logEvent(event);
        }

        public void mapCleared(MapEvent event) {
            this.logEvent(event);
        }

        private void logEvent(EntryEvent<K, V> event) {
            if (this.logger != null && this.logger.isEnabled(this.level)) {
                Localise.log(this.logger, this.level, "Entry %1$s %2$s", event.getKey(), event.getEventType().toString().toLowerCase());
            }
        }

        private void logEvent(MapEvent event) {
            if (this.logger != null && this.logger.isEnabled(this.level)) {
                Localise.log(this.logger, this.level, "Entry %1$s %2$s", event.getName(), event.getEventType().toString().toLowerCase());
            }
        }
    }
}

