/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoCalendar;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Set;
import java.util.TreeSet;

public class CalendarJobsQuery
extends AbstractCommandMessage<CalendarJobsQuery> {
    private static final String MESSAGE_TAG = "command";
    private Name name;

    public CalendarJobsQuery() {
    }

    public CalendarJobsQuery(Name name) {
        this.name = name;
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCalendar.QueryJobs.Builder toProto() {
        ProtoCalendar.QueryJobs.Builder builder = ProtoCalendar.QueryJobs.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        return builder;
    }

    @Override
    public CalendarJobsQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCalendar.QueryJobs proto = ProtoCalendar.QueryJobs.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = new Name(proto.getName());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private Set<Name> jobs = new TreeSet<Name>();

        public Response() {
        }

        public Response(CalendarJobsQuery query) {
            this.name = query.name;
        }

        public Name getName() {
            return this.name;
        }

        public Response addJob(Name name) {
            this.jobs.add(name);
            return this;
        }

        public Set<Name> getJobs() {
            return this.jobs;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.jobs.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoCalendar.QueryJobsResponse.Builder toProto() {
            ProtoCalendar.QueryJobsResponse.Builder builder = ProtoCalendar.QueryJobsResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name.toProto());
            for (Name name : this.jobs) {
                builder.addJobs(name.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoCalendar.QueryJobsResponse proto = ProtoCalendar.QueryJobsResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = new Name(proto.getName());
            for (ProtoCore.Name name : proto.getJobsList()) {
                this.jobs.add(new Name().fromProto(name.toByteArray()));
            }
            return this;
        }
    }
}

