/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.proto.ProtoCalendar;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CalendarQuery
extends AbstractCommandMessage<CalendarQuery> {
    private static final String MESSAGE_TAG = "command";
    private Filter filter = new Filter();
    private List<String> changeIds = new ArrayList<String>();

    public CalendarQuery() {
    }

    public CalendarQuery(Name name) {
        this(name, null);
    }

    public CalendarQuery(Name name, List<String> changeIds) {
        this.filter = new Filter(name);
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public CalendarQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public CalendarQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCalendar.Query.Builder toProto() {
        ProtoCalendar.Query.Builder builder = ProtoCalendar.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public CalendarQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCalendar.Query proto = ProtoCalendar.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<String> changeIds = new ArrayList<String>();
        private List<Calendar> calendars = new ArrayList<Calendar>();

        public Response addCalendar(Calendar calendar) {
            if (calendar != null) {
                this.calendars.add(calendar);
            }
            return this;
        }

        public Calendar getCalendar() {
            return this.result.wasSuccess() && this.calendars.size() == 1 ? this.calendars.iterator().next() : null;
        }

        public List<Calendar> getCalendars() {
            return this.calendars;
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.calendars.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoCalendar.QueryResponse.Builder toProto() {
            ProtoCalendar.QueryResponse.Builder builder = ProtoCalendar.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.addAllChangeIds(this.changeIds);
            for (Calendar calendar : this.calendars) {
                builder.addCalendars(calendar.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoCalendar.QueryResponse proto = ProtoCalendar.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            for (ProtoCalendar.Calendar calendar : proto.getCalendarsList()) {
                this.calendars.add(new Calendar().fromProto(calendar.toByteArray()));
            }
            return this;
        }
    }
}

