/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.proto.ProtoChange;
import com.google.protobuf.InvalidProtocolBufferException;
import edu.emory.mathcs.backport.java.util.Collections;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Change
implements Message<Change> {
    private static final String MESSAGE_TAG = "change";
    static Pattern changeIdRelative = Pattern.compile("(0|-[0-9]+)");
    static Pattern changeIdRev = Pattern.compile("[a-f0-9]+");
    static Pattern entryV1Pattern = Pattern.compile("(.+?):(.+?) (created|updated|removed) .+");
    static Pattern entryV2Pattern = Pattern.compile("^(.+?):(.+) ([-+~])$", 8);
    private Name name;
    private String id;
    private long timestamp;
    private String author;
    private String message;

    public Change() {
    }

    public Change(Name name, String id, long timestamp, String author, String message) {
        this.name = name;
        this.id = id;
        this.timestamp = timestamp;
        this.author = author;
        this.message = message.trim();
    }

    public Name getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<Entry> getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.message.indexOf("\n") > 0) {
            Matcher matcher = entryV2Pattern.matcher(this.message);
            while (matcher.find()) {
                entries.add(new Entry(matcher.group(1), Name.parse(matcher.group(2)), Action.valueOfTag(matcher.group(3))));
            }
            if (entries.size() > 1) {
                Collections.sort(entries);
            }
        } else {
            Matcher matcher = entryV1Pattern.matcher(this.message);
            if (matcher.matches()) {
                entries.add(new Entry(matcher.group(1), Name.parse(matcher.group(2)), Action.valueOf(matcher.group(3).toUpperCase())));
            }
        }
        return entries;
    }

    public int getEntryCount() {
        int count = 0;
        for (int i = 0; i < this.message.length(); ++i) {
            if (this.message.charAt(i) != '\n') continue;
            ++count;
        }
        return count > 0 ? count : 1;
    }

    public String getMessage() {
        return this.getMessage(true);
    }

    public String getMessage(boolean summary) {
        int i;
        Object msg = summary ? ((i = this.message.indexOf("\n")) > 0 ? this.getAction().getLabel(true) + " by " + this.message.substring(0, i) : ((i = this.message.indexOf(32)) > 0 ? StringUtils.capitalise(this.message.substring(++i)) : this.message)) : this.message;
        return msg;
    }

    public Action getAction() {
        Action action;
        int i = this.message.indexOf(10);
        if (i > 0) {
            String s = this.name.toString();
            i = this.message.indexOf(s, i);
            if (i > 0) {
                i = this.message.indexOf(32, i) + 1;
            }
            action = i > 0 && i < this.message.length() ? Action.valueOfTag(this.message.substring(i, i + 1)) : Action.UNKNOWN;
        } else {
            int j;
            i = this.message.indexOf(32) + 1;
            int n = j = i > 1 ? this.message.indexOf(32, i) : -1;
            if (j > i) {
                try {
                    action = Action.valueOf(this.message.substring(i, j).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    action = Action.UNKNOWN;
                }
            } else {
                action = Action.UNKNOWN;
            }
        }
        return action;
    }

    public String getUser() {
        int j;
        int i;
        if (this.message.indexOf("\n") > 0) {
            i = 0;
            j = this.message.indexOf(47);
        } else {
            i = this.message.indexOf(" by ") + 4;
            j = i > 4 ? this.message.indexOf(47, i) : -1;
        }
        return j > i ? this.message.substring(i, j) : Localise.format("Unknown");
    }

    public String getHost() {
        int i = (this.message.indexOf("\n") > 0 ? this.message.indexOf(58) : this.message.lastIndexOf(58)) + 1;
        int j = i > 1 ? this.message.indexOf(32, i) : -1;
        return j > i ? this.message.substring(i, j) : Localise.format("Unknown");
    }

    public String getClient() {
        return this.getClient(false);
    }

    public String getClient(boolean full) {
        int j;
        int i = this.message.indexOf(" using ") + 7;
        if (i > 7) {
            if (full) {
                j = this.message.indexOf("\n");
                if (j < 0) {
                    j = this.message.length();
                }
            } else {
                j = this.message.indexOf(47, i);
            }
        } else {
            j = -1;
        }
        return j > i ? this.message.substring(i, j) : Localise.format("Unknown");
    }

    public String getReference() {
        int i = this.message.indexOf("\n");
        int j = this.message.indexOf("]");
        if (j < i) {
            i = this.message.indexOf("[") + 1;
        }
        return i < j ? this.message.substring(i, j) : "";
    }

    public static boolean isChangeId(String value) {
        return changeIdRelative.matcher(value).matches() || changeIdRev.matcher(value).matches();
    }

    public static String getChangeHeader(Connection connection, String reference) {
        String clientVersion;
        String clientType;
        String clientName;
        String clientUserName;
        String hostName;
        String hostUserName;
        if (connection != null) {
            hostUserName = connection.getOsUserName();
            hostName = connection.getClientHostName();
            clientUserName = connection.getClientUserName();
            clientName = connection.getClientName();
            clientType = StringUtils.capitalise((Object)connection.getClientType());
            clientVersion = connection.getClientVersion();
        } else {
            hostUserName = Program.getUserName();
            hostName = NetUtils.getHostName();
            clientUserName = (String)Configs.get("BEYONDCRON_SERVER_USER_NAME");
            clientName = Program.getName();
            clientType = StringUtils.capitalise((Object)Connection.Type.SERVER);
            clientVersion = Program.getVersion().toString();
        }
        return Change.getChangeHeader(hostUserName, hostName, clientUserName, clientName, clientType, clientVersion, reference);
    }

    public static String getChangeHeader(String hostUserName, String hostName, String clientUserName, String clientName, String clientType, String clientVersion, String reference) {
        if (StringUtils.isNullOrEmpty(reference)) {
            return String.format("%1$s/%2$s:%3$s using %4$s/%5$s (%6$s)", clientUserName, hostUserName, hostName, clientName, clientType, clientVersion);
        }
        return String.format("%1$s/%2$s:%3$s using %4$s/%5$s (%6$s) reference [%7$s]", clientUserName, hostUserName, hostName, clientName, clientType, clientVersion, reference);
    }

    public static String getChangeEntry(Name name, String tag, Action action) {
        return String.format("%2$s:%1$s %3$s", name, tag, action.tag);
    }

    public static int createGroup() {
        return UUID.randomUUID().hashCode();
    }

    public String toString() {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        lines.add((CallSite)((Object)("   Name: " + this.name)));
        lines.add((CallSite)((Object)("     Id: " + this.id)));
        lines.add((CallSite)((Object)("   Time: " + new Date(this.timestamp))));
        lines.add((CallSite)((Object)(" Author: " + this.author)));
        lines.add((CallSite)((Object)("   User: " + this.getUser())));
        lines.add((CallSite)((Object)(" Action: " + this.getAction())));
        lines.add((CallSite)((Object)("Message: " + this.getMessage(true))));
        return StringUtils.join("\n", lines);
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoChange.Change.Builder toProto() {
        ProtoChange.Change.Builder builder = ProtoChange.Change.newBuilder();
        builder.setName(this.name.toProto());
        builder.setId(this.id);
        builder.setTimestamp(this.timestamp);
        builder.setAuthor(this.author);
        builder.setMessage(this.message);
        return builder;
    }

    @Override
    public Change fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoChange.Change proto = ProtoChange.Change.parseFrom(data);
        this.name = new Name(proto.getName());
        this.id = proto.getId();
        this.timestamp = proto.getTimestamp();
        this.author = proto.getAuthor();
        this.message = proto.getMessage();
        return this;
    }

    public static class Entry
    implements Comparable<Entry> {
        private String tag;
        private Name name;
        private Action action;

        public Entry(String tag, Name name, Action action) {
            this.tag = tag;
            this.name = name;
            this.action = action;
        }

        public Name getName() {
            return this.name;
        }

        public String getTag() {
            return this.tag;
        }

        public Action getAction() {
            return this.action;
        }

        public String toString() {
            return this.tag + " " + this.name + " " + this.action.getLabel(true).toLowerCase();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            return this.compareTo((Entry)obj) == 0;
        }

        @Override
        public int compareTo(Entry that) {
            int i = this.name.compareTo(that.name);
            if (i == 0) {
                i = this.tag.compareTo(that.tag);
            }
            if (i == 0) {
                i = this.action.tag.compareTo(that.action.tag);
            }
            return i;
        }
    }

    public static enum Action {
        CREATED("Create", "Created", "+"),
        REMOVED("Remove", "Removed", "-"),
        UPDATED("Update", "Updated", "~"),
        UNKNOWN("Unknown", "Unknown", "?");

        private String label;
        private String labelPast;
        private String tag;

        private Action(String label, String labelPast, String tag) {
            this.label = label;
            this.labelPast = labelPast;
            this.tag = tag;
        }

        public String getLabel(boolean past) {
            return past ? this.labelPast : this.label;
        }

        public String getTag() {
            return this.tag;
        }

        public static Action valueOfTag(String tag) {
            Action action;
            switch (tag) {
                case "+": {
                    action = CREATED;
                    break;
                }
                case "-": {
                    action = REMOVED;
                    break;
                }
                case "~": {
                    action = UPDATED;
                    break;
                }
                default: {
                    action = UNKNOWN;
                }
            }
            return action;
        }
    }
}

