/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoCluster;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class ClusterQuery
extends AbstractCommandMessage<ClusterQuery> {
    private static final String MESSAGE_TAG = "query";
    private Set<String> filters = new TreeSet<String>();

    public ClusterQuery() {
    }

    public ClusterQuery(List<String> filters) {
        this.filters.addAll(filters);
    }

    public Set<String> getFilters() {
        return this.filters;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCluster.Query.Builder toProto() {
        ProtoCluster.Query.Builder builder = ProtoCluster.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (!this.filters.isEmpty()) {
            builder.addAllFilters(this.filters);
        }
        return builder;
    }

    @Override
    public ClusterQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCluster.Query proto = ProtoCluster.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filters.clear();
        if (proto.getFiltersCount() > 0) {
            this.filters.addAll((Collection<String>)proto.getFiltersList());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Set<String> filters = new TreeSet<String>();
        private JSONObject info = new JSONObject();

        public Response() {
        }

        public Response(ClusterQuery query) {
            this.filters.addAll(query.filters);
        }

        public Set<String> getFilters() {
            return this.filters;
        }

        public Response setInfo(JSONObject info) {
            this.info = info;
            return this;
        }

        public JSONObject getInfo() {
            return this.info;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoCluster.QueryResponse.Builder toProto() {
            String s;
            ProtoCluster.QueryResponse.Builder builder = ProtoCluster.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            if (!this.filters.isEmpty()) {
                builder.addAllFilters(this.filters);
            }
            if (!(s = this.info.toString()).isEmpty()) {
                builder.setInfo(s);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoCluster.QueryResponse proto = ProtoCluster.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.filters.clear();
            if (proto.getFiltersCount() > 0) {
                this.filters.addAll((Collection<String>)proto.getFiltersList());
            }
            this.info = proto.hasInfo() ? new JSONObject(proto.getInfo()) : new JSONObject();
            return this;
        }
    }
}

