/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoConnection;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class ConnectionQuery
extends AbstractCommandMessage<ConnectionQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();

    public ConnectionQuery() {
    }

    public ConnectionQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ConnectionQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConnection.Query.Builder toProto() {
        ProtoConnection.Query.Builder builder = ProtoConnection.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        return builder;
    }

    @Override
    public ConnectionQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConnection.Query proto = ProtoConnection.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Connection> connections = new ArrayList<Connection>();

        public Response addConnection(Connection connection) {
            this.connections.add(connection);
            return this;
        }

        public List<Connection> getConnections() {
            return this.connections;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.connections.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoConnection.QueryResponse.Builder toProto() {
            ProtoConnection.QueryResponse.Builder builder = ProtoConnection.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Connection connection : this.connections) {
                builder.addConnections(connection.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoConnection.QueryResponse proto = ProtoConnection.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoConnection.Connection connection : proto.getConnectionsList()) {
                this.connections.add(new Connection().fromProto(connection.toByteArray()));
            }
            return this;
        }
    }
}

