/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoTime;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDateTime;

public class DateTime
implements Message<DateTime> {
    private static final String MESSAGE_TAG = "dateTime";
    private LocalDateTime dateTime;

    public DateTime() {
        this.dateTime = LocalDateTime.now();
    }

    public DateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTime(ProtoTime.DateTime proto) throws InvalidProtocolBufferException {
        this.fromProto(proto.toByteArray());
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoTime.DateTime.Builder toProto() {
        ProtoTime.DateTime.Builder builder = ProtoTime.DateTime.newBuilder();
        builder.setYear(this.dateTime.getYear());
        builder.setMonth(this.dateTime.getMonthValue());
        builder.setDay(this.dateTime.getDayOfMonth());
        builder.setHour(this.dateTime.getHour());
        builder.setMinute(this.dateTime.getMinute());
        builder.setSecond(this.dateTime.getSecond());
        return builder;
    }

    @Override
    public DateTime fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoTime.DateTime proto = ProtoTime.DateTime.parseFrom(data);
        this.dateTime = LocalDateTime.of(proto.getYear(), proto.getMonth(), proto.getDay(), proto.getHour(), proto.getMinute(), proto.getSecond());
        return this;
    }
}

