/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.security.ACL;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.proto.ProtoGroup;
import com.google.protobuf.InvalidProtocolBufferException;

public class Group {

    public static class Entry
    implements Comparable<Entry>,
    Message<Entry> {
        private static final String MESSAGE_TAG = "entry";
        private Type type;
        private String name;
        private String description;

        public Entry() {
        }

        public Entry(ACL acl) {
            this(Type.ACL, acl.getName().getName(), null);
        }

        public Entry(Calendar calendar) {
            this(Type.CALENDAR, calendar.getName().getName(), calendar.getDescription());
        }

        public Entry(Job job) {
            this(Type.JOB, job.getName().getName(), job.getDescription());
        }

        public Entry(Name group) {
            this(Type.GROUP, group.getName(), null);
        }

        public Entry(Type type, String name, String description) {
            this.type = type;
            this.name = name;
            this.description = description != null ? StringUtils.stripDuplicateSpaces(description) : "";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            if (StringUtils.isNullOrEmpty(this.description)) {
                return this.type + " " + this.name;
            }
            return this.type + " " + this.name + " " + this.description;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            return this.compareTo((Entry)obj) == 0;
        }

        @Override
        public int compareTo(Entry that) {
            int i = this.name.compareTo(that.name);
            if (i != 0) {
                return i;
            }
            return this.type.compareTo(that.type);
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoGroup.Entry.Builder toProto() {
            ProtoGroup.Entry.Builder builder = ProtoGroup.Entry.newBuilder();
            if (this.type != Type.JOB) {
                builder.setType(this.type.toProto());
            }
            builder.setName(this.name);
            if (!StringUtils.isNullOrEmpty(this.description)) {
                builder.setDescription(this.description);
            }
            return builder;
        }

        @Override
        public Entry fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoGroup.Entry proto = ProtoGroup.Entry.parseFrom(data);
            this.type = Type.fromProto(proto.getType());
            this.name = proto.getName();
            this.description = proto.hasDescription() ? proto.getDescription() : "";
            return this;
        }

        public static enum Type {
            ACL("ACL", "+"),
            PROPERTY("Property", "p"),
            CALENDAR("Calendar", "c"),
            GROUP("Group", "g"),
            JOB("Job", "j");

            private String label;
            private String tag;
            private static final EnumMap<Type, ProtoGroup.Entry.Type> typeMap;

            private Type(String label, String tag) {
                this.label = label;
                this.tag = tag;
            }

            public String getLabel() {
                return this.label;
            }

            public String getTag() {
                return this.tag;
            }

            public static Type fromProto(ProtoGroup.Entry.Type type) {
                return typeMap.getA(type);
            }

            public ProtoGroup.Entry.Type toProto() {
                return typeMap.getB(this);
            }

            static {
                typeMap = new EnumMap<Type, ProtoGroup.Entry.Type>(Type.class, ProtoGroup.Entry.Type.class);
            }
        }
    }
}

