/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Group;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoGroup;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class GroupQuery
extends AbstractCommandMessage<GroupQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name;

    public GroupQuery() {
    }

    public GroupQuery(Name name) {
        this.name = name;
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoGroup.Query.Builder toProto() {
        ProtoGroup.Query.Builder builder = ProtoGroup.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (!this.name.equals(Name.ROOT)) {
            builder.setName(this.name.toProto());
        }
        return builder;
    }

    @Override
    public GroupQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoGroup.Query proto = ProtoGroup.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.hasName() ? new Name(proto.getName()) : Name.ROOT;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Set<Group.Entry> entries = new TreeSet<Group.Entry>();

        public Response addEntry(Group.Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public Collection<Group.Entry> getEntries() {
            return this.entries;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoGroup.QueryResponse.Builder toProto() {
            ProtoGroup.QueryResponse.Builder builder = ProtoGroup.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Group.Entry entry : this.entries) {
                builder.addEntries(entry.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoGroup.QueryResponse proto = ProtoGroup.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoGroup.Entry entry : proto.getEntriesList()) {
                this.entries.add(new Group.Entry().fromProto(entry.toByteArray()));
            }
            return this;
        }
    }
}

