/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoHostACL;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HostACLQuery
extends AbstractCommandMessage<HostACLQuery> {
    private static final String MESSAGE_TAG = "query";
    private String userRole = null;
    private List<String> changeIds = new ArrayList<String>();

    public HostACLQuery() {
    }

    public HostACLQuery(List<String> changeIds) {
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public HostACLQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoHostACL.Query.Builder toProto() {
        ProtoHostACL.Query.Builder builder = ProtoHostACL.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (!StringUtils.isNullOrEmpty(this.userRole)) {
            builder.setUserRole(this.userRole);
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public HostACLQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoHostACL.Query proto = ProtoHostACL.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.userRole = proto.hasUserRole() ? proto.getUserRole() : null;
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<String> changeIds = new ArrayList<String>();
        private List<List<HostACL>> values = new ArrayList<List<HostACL>>();

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        public Response addValues(Collection<HostACL> hostACLs) {
            this.values.add(new ArrayList<HostACL>(hostACLs));
            return this;
        }

        public List<List<HostACL>> getValues() {
            return this.values;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoHostACL.QueryResponse.Builder toProto() {
            ProtoHostACL.QueryResponse.Builder builder = ProtoHostACL.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.addAllChangeIds(this.changeIds);
            for (List<HostACL> valueList : this.values) {
                ProtoHostACL.ACLList.Builder valueBuilder = ProtoHostACL.ACLList.newBuilder();
                for (HostACL value : valueList) {
                    valueBuilder.addValues(value.toProto());
                }
                builder.addValues(valueBuilder);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoHostACL.QueryResponse proto = ProtoHostACL.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.values.clear();
            for (ProtoHostACL.ACLList hostACLsProto : proto.getValuesList()) {
                ArrayList<HostACL> valueList = new ArrayList<HostACL>();
                for (ProtoHostACL.ACL value : hostACLsProto.getValuesList()) {
                    valueList.add(new HostACL().fromProto(value.toByteArray()));
                }
                this.values.add(valueList);
            }
            return this;
        }
    }
}

