/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoICalendar;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;

public class ICalendarCommand
extends AbstractCommandMessage<ICalendarCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private URI uri;

    public ICalendarCommand() {
    }

    public ICalendarCommand(URI uri, Action action) {
        this.uri = uri;
        this.action = action;
    }

    public URI getURI() {
        return this.uri;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoICalendar.Command.Builder toProto() {
        ProtoICalendar.Command.Builder builder = ProtoICalendar.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setUri(this.uri.toString());
        return builder;
    }

    @Override
    public ICalendarCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoICalendar.Command proto = ProtoICalendar.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.uri = NetUtils.parseURI(proto.getUri());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private URI uri;
        private Action action;

        public Response() {
        }

        public Response(ICalendarCommand command) {
            this.uri = command.uri;
            this.action = command.action;
        }

        public URI getURI() {
            return this.uri;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoICalendar.CommandResponse.Builder toProto() {
            ProtoICalendar.CommandResponse.Builder builder = ProtoICalendar.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setUri(this.uri.toString());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoICalendar.CommandResponse proto = ProtoICalendar.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.uri = NetUtils.parseURI(proto.getUri());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        DELETE,
        REFRESH;

        static EnumMap<Action, ProtoICalendar.Command.Action> actionMap;

        public static Action fromProto(ProtoICalendar.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoICalendar.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoICalendar.Command.Action>(Action.class, ProtoICalendar.Command.Action.class);
        }
    }
}

