/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.calendar.ICalendar;
import com.beyondcron.messaging.proto.ProtoICalendar;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;
import java.util.Set;
import java.util.TreeSet;

public class ICalendarQuery
extends AbstractCommandMessage<ICalendarQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();
    private URI uri = null;

    public ICalendarQuery() {
    }

    public ICalendarQuery(URI uri) {
        this.uri = uri;
    }

    public ICalendarQuery(Filter filter) {
        this.filter = filter;
    }

    public URI getURI() {
        return this.uri;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ICalendarQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoICalendar.Query.Builder toProto() {
        ProtoICalendar.Query.Builder builder = ProtoICalendar.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        if (this.uri != null) {
            builder.setUri(this.uri.toString());
        }
        return builder;
    }

    @Override
    public ICalendarQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoICalendar.Query proto = ProtoICalendar.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.uri = proto.hasUri() ? NetUtils.parseURI(proto.getUri()) : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Set<ICalendar> icalendars = new TreeSet<ICalendar>();

        public Response addICalendar(ICalendar icalendar) {
            this.icalendars.add(icalendar);
            return this;
        }

        public ICalendar getICalendar() {
            return this.result.wasSuccess() && this.icalendars.size() == 1 ? this.icalendars.iterator().next() : null;
        }

        public Set<ICalendar> getICalendars() {
            return this.icalendars;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.icalendars.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoICalendar.QueryResponse.Builder toProto() {
            ProtoICalendar.QueryResponse.Builder builder = ProtoICalendar.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (ICalendar icalendar : this.icalendars) {
                builder.addCalendars(icalendar.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoICalendar.QueryResponse proto = ProtoICalendar.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoICalendar.ICalendar icalendar : proto.getCalendarsList()) {
                this.icalendars.add(new ICalendar().fromProto(icalendar.toByteArray()));
            }
            return this;
        }
    }
}

