/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobCommand
extends AbstractCommandMessage<JobCommand> {
    private static final String MESSAGE_TAG = "command";
    private Name name;
    private Action action;
    private Job job = null;

    public JobCommand() {
    }

    public JobCommand(Name name, Action action) {
        this.name = name;
        this.action = action;
    }

    public JobCommand(Job job, Action action) {
        this.name = job.getName();
        this.action = action;
        this.job = job;
    }

    public Action getAction() {
        return this.action;
    }

    public Name getName() {
        return this.name;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Command.Builder toProto() {
        ProtoJob.Command.Builder builder = ProtoJob.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name.toProto());
        if (this.job != null) {
            builder.setJob(this.job.toProto());
        }
        return builder;
    }

    @Override
    public JobCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Command proto = ProtoJob.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.name = new Name(proto.getName());
        this.job = proto.hasJob() ? Job.parseFromProto(proto.getJob().toByteArray()) : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private Action action;

        public Response() {
        }

        public Response(JobCommand command) {
            this.name = command.name;
            this.action = command.action;
        }

        public Name getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.CommandResponse.Builder toProto() {
            ProtoJob.CommandResponse.Builder builder = ProtoJob.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setName(this.name.toProto());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.CommandResponse proto = ProtoJob.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.name = new Name(proto.getName());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

        static EnumMap<Action, ProtoJob.Command.Action> actionMap;

        public static Action fromProto(ProtoJob.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoJob.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoJob.Command.Action>(Action.class, ProtoJob.Command.Action.class);
        }
    }
}

