/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobControl
extends AbstractCommandMessage<JobControl> {
    private static final String MESSAGE_TAG = "command";
    private Name name;
    private Job.Action action;
    private Job.Mode mode;
    private boolean force = false;

    public JobControl() {
    }

    public JobControl(Name name, Job.Action action) {
        this(name, action, null, false);
    }

    public JobControl(Name name, Job.Action action, boolean force) {
        this(name, action, null, force);
    }

    public JobControl(Name name, Job.Mode mode) {
        this(name, null, mode, false);
    }

    public JobControl(Name name, Job.Action action, Job.Mode mode, boolean force) {
        this.name = name;
        this.action = action;
        this.mode = mode;
        this.force = force;
    }

    public Name getName() {
        return this.name;
    }

    public Job.Action getAction() {
        return this.action;
    }

    public Job.Mode getMode() {
        return this.mode;
    }

    public boolean isForce() {
        return this.force;
    }

    public JobControl setForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Control.Builder toProto() {
        ProtoJob.Control.Builder builder = ProtoJob.Control.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        if (this.action != null) {
            builder.setAction(this.action.toProto());
        }
        if (this.mode != null) {
            builder.setMode(this.mode.toProto());
        }
        if (this.force) {
            builder.setForce(true);
        }
        return builder;
    }

    @Override
    public JobControl fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Control proto = ProtoJob.Control.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = new Name(proto.getName());
        this.action = proto.hasAction() ? Job.Action.fromProto(proto.getAction()) : null;
        this.mode = proto.hasMode() ? Job.Mode.fromProto(proto.getMode()) : null;
        this.force = proto.getForce();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private Job.Action action;
        private Job.Mode mode;
        private boolean force;

        public Response() {
        }

        public Response(Name name) {
            this(name, null, null, false);
        }

        public Response(Name name, Job.Action action, boolean force) {
            this(name, action, null, force);
        }

        public Response(Name name, Job.Mode mode) {
            this(name, null, mode, false);
        }

        public Response(Name name, Job.Action action, Job.Mode mode, boolean force) {
            this.name = name;
            this.action = action;
            this.mode = mode;
            this.force = force;
        }

        public Name getName() {
            return this.name;
        }

        public Job.Action getAction() {
            return this.action;
        }

        public Job.Mode getMode() {
            return this.mode;
        }

        public boolean isForce() {
            return this.force;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.ControlResponse.Builder toProto() {
            ProtoJob.ControlResponse.Builder builder = ProtoJob.ControlResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name.toProto());
            if (this.action != null) {
                builder.setAction(this.action.toProto());
            }
            if (this.mode != null) {
                builder.setMode(this.mode.toProto());
            }
            if (this.force) {
                builder.setForce(true);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.ControlResponse proto = ProtoJob.ControlResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = new Name(proto.getName());
            this.action = proto.hasAction() ? Job.Action.fromProto(proto.getAction()) : null;
            this.mode = proto.hasMode() ? Job.Mode.fromProto(proto.getMode()) : null;
            this.force = proto.getForce();
            return this;
        }
    }
}

