/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobExecute
implements Message<JobExecute> {
    private static final String MESSAGE_TAG = "command";
    private Job job;
    private Job.Action action;
    private long startTimestamp;
    private Trigger trigger;
    private Status triggerStatus;

    public JobExecute() {
    }

    public JobExecute(Job job, Job.Action action) {
        this(job, action, System.currentTimeMillis(), null, null);
    }

    public JobExecute(Job job, Job.Action action, long startTimestamp, Trigger trigger, Status triggerStatus) {
        this.job = job;
        this.action = action;
        this.startTimestamp = startTimestamp;
        this.trigger = trigger;
        this.triggerStatus = triggerStatus;
    }

    public Job getJob() {
        return this.job;
    }

    public Job.Action getAction() {
        return this.action;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Status getTriggerStatus() {
        return this.triggerStatus;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Execute.Builder toProto() {
        ProtoJob.Execute.Builder builder = ProtoJob.Execute.newBuilder();
        builder.setJob(this.job.toProto());
        builder.setAction(this.action.toProto());
        builder.setStartTimestamp(this.startTimestamp);
        if (this.trigger != null && this.trigger.getType() != Trigger.Type.SCHEDULE) {
            builder.setTrigger(this.trigger.toProto());
        }
        if (this.triggerStatus != null) {
            builder.setTriggerStatus(this.triggerStatus.toProto());
        }
        return builder;
    }

    @Override
    public JobExecute fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Execute proto = ProtoJob.Execute.parseFrom(data);
        this.job = Job.parseFromProto(proto.getJob().toByteArray());
        this.action = Job.Action.fromProto(proto.getAction());
        this.startTimestamp = proto.getStartTimestamp();
        this.trigger = proto.hasTrigger() ? new Trigger().fromProto(proto.getTrigger().toByteArray()) : new Trigger();
        this.triggerStatus = proto.hasTriggerStatus() ? new Status().fromProto(proto.getTriggerStatus().toByteArray()) : null;
        return this;
    }
}

