/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobHistoryClear
extends AbstractCommandMessage<JobHistoryClear> {
    private static final String MESSAGE_TAG = "clear";
    private Name name;
    private long timestamp;

    public JobHistoryClear() {
    }

    public JobHistoryClear(Name name) {
        this(name, -1L);
    }

    public JobHistoryClear(Name name, long timestamp) {
        this.name = name;
        this.timestamp = timestamp;
    }

    public Name getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.HistoryClear.Builder toProto() {
        ProtoJob.HistoryClear.Builder builder = ProtoJob.HistoryClear.newBuilder();
        builder.setClientId(this.clientId);
        if (this.name != null) {
            builder.setName(this.name.toProto());
        }
        if (this.timestamp > -1L) {
            builder.setTimestamp(this.timestamp);
        }
        return builder;
    }

    @Override
    public JobHistoryClear fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.HistoryClear proto = ProtoJob.HistoryClear.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.hasName() ? new Name().fromProto(proto.getName().toByteArray()) : null;
        this.timestamp = proto.getTimestamp();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private int removed = 0;

        public Response() {
        }

        public Response(JobHistoryClear command) {
            this.name = command.name;
        }

        public Name getName() {
            return this.name;
        }

        public int getRemoved() {
            return this.removed;
        }

        public Response setRemoved(int removed) {
            this.removed = removed;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.HistoryClearResponse.Builder toProto() {
            ProtoJob.HistoryClearResponse.Builder builder = ProtoJob.HistoryClearResponse.newBuilder();
            builder.setResult(this.result.toProto());
            if (this.name != null) {
                builder.setName(this.name.toProto());
            }
            if (this.removed > -1) {
                builder.setRemoved(this.removed);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.HistoryClearResponse proto = ProtoJob.HistoryClearResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = proto.hasName() ? new Name().fromProto(proto.getName().toByteArray()) : null;
            this.removed = proto.getRemoved();
            return this;
        }
    }
}

