/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class JobHistoryQuery
extends AbstractCommandMessage<JobHistoryQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name;
    private long startTimestamp;
    private long endTimestamp;

    public JobHistoryQuery() {
    }

    public JobHistoryQuery(Name name, long startTimestamp) {
        this(name, startTimestamp, -1L);
    }

    public JobHistoryQuery(Name name, long startTimestamp, long endTimestamp) {
        this.name = name;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    public Name getName() {
        return this.name;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.HistoryQuery.Builder toProto() {
        ProtoJob.HistoryQuery.Builder builder = ProtoJob.HistoryQuery.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        builder.setStartTimestamp(this.startTimestamp);
        if (this.endTimestamp > 0L) {
            builder.setEndTimestamp(this.endTimestamp);
        }
        return builder;
    }

    @Override
    public JobHistoryQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.HistoryQuery proto = ProtoJob.HistoryQuery.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = new Name().fromProto(proto.getName().toByteArray());
        this.startTimestamp = proto.getStartTimestamp();
        this.endTimestamp = proto.getEndTimestamp();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private List<Status> statuses = new ArrayList<Status>();

        public Response() {
        }

        public Response(JobHistoryQuery query) {
            this.name = query.name;
        }

        public Name getName() {
            return this.name;
        }

        public Response addStatuses(List<Status> statuses) {
            this.statuses.addAll(statuses);
            return this;
        }

        public List<Status> getStatuses() {
            return this.statuses;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.statuses.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.HistoryQueryResponse.Builder toProto() {
            ProtoJob.HistoryQueryResponse.Builder builder = ProtoJob.HistoryQueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name.toProto());
            for (Status status : this.statuses) {
                builder.addStatuses(status.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.HistoryQueryResponse proto = ProtoJob.HistoryQueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = new Name().fromProto(proto.getName().toByteArray());
            for (ProtoJob.Status status : proto.getStatusesList()) {
                this.statuses.add(new Status().fromProto(status.toByteArray()));
            }
            return this;
        }
    }
}

