/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobOutputQuery
extends AbstractCommandMessage<JobOutputQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name;
    private long timestamp;

    public JobOutputQuery() {
    }

    public JobOutputQuery(Name name) {
        this(name, -1L);
    }

    public JobOutputQuery(Name name, long timestamp) {
        this.name = name;
        this.timestamp = timestamp;
    }

    public Name getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.OutputQuery.Builder toProto() {
        ProtoJob.OutputQuery.Builder builder = ProtoJob.OutputQuery.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        if (this.timestamp > 0L) {
            builder.setTimestamp(this.timestamp);
        }
        return builder;
    }

    @Override
    public JobOutputQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.OutputQuery proto = ProtoJob.OutputQuery.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = new Name().fromProto(proto.getName().toByteArray());
        this.timestamp = proto.getTimestamp();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private long timestamp = -1L;
        private Output output = null;

        public Response() {
        }

        public Response(JobOutputQuery query) {
            this.name = query.name;
        }

        public Response setStatus(Status status) {
            this.name = status.getName();
            this.timestamp = status.getTimestamp();
            this.output = status.getOutput();
            return this;
        }

        public Name getName() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Output getOutput() {
            return this.output;
        }

        public boolean hasOutput() {
            return this.output != null && !this.output.isEmpty();
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.OutputQueryResponse.Builder toProto() {
            ProtoJob.OutputQueryResponse.Builder builder = ProtoJob.OutputQueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name.toProto());
            if (this.timestamp > 0L) {
                builder.setTimestamp(this.timestamp);
            }
            if (this.output != null) {
                builder.setOutput(this.output.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.OutputQueryResponse proto = ProtoJob.OutputQueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = new Name().fromProto(proto.getName().toByteArray());
            this.timestamp = proto.getTimestamp();
            this.output = proto.hasOutput() ? new Output().fromProto(proto.getOutput().toByteArray()) : null;
            return this;
        }
    }
}

