/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobQuery
extends AbstractCommandMessage<JobQuery> {
    private static final String MESSAGE_TAG = "query";
    private boolean summary = false;
    private Filter filter = new Filter();
    private List<String> changeIds = new ArrayList<String>();

    public JobQuery() {
    }

    public JobQuery(Name name) {
        this(name, null);
    }

    public JobQuery(Name name, List<String> changeIds) {
        this.filter = new Filter(name.getPath());
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public JobQuery(boolean summary) {
        this.summary = summary;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public JobQuery setSummary(boolean summary) {
        this.summary = summary;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public JobQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public JobQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Query.Builder toProto() {
        ProtoJob.Query.Builder builder = ProtoJob.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.summary) {
            builder.setSummary(true);
        }
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public JobQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Query proto = ProtoJob.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.summary = proto.getSummary();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private boolean summary = false;
        private Result result = new Result();
        private List<String> changeIds = new ArrayList<String>();
        private List<Job> jobs = new ArrayList<Job>();

        public Response() {
        }

        public Response(JobQuery query) {
            this.summary = query.summary;
        }

        public boolean isSummary() {
            return this.summary;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.jobs.isEmpty();
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        public Response addJob(Job job) {
            if (job != null) {
                this.jobs.add(job);
            }
            return this;
        }

        public List<Job> getJobs() {
            return this.jobs;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.QueryResponse.Builder toProto() {
            ProtoJob.QueryResponse.Builder builder = ProtoJob.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            if (this.summary) {
                builder.setSummary(true);
            }
            builder.addAllChangeIds(this.changeIds);
            for (Job job : this.jobs) {
                builder.addJobs(job.toProto(this.summary));
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.QueryResponse proto = ProtoJob.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.summary = proto.getSummary();
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.jobs.clear();
            for (ProtoJob.Job job : proto.getJobsList()) {
                this.jobs.add(Job.parseFromProto(job.toByteArray()));
            }
            return this;
        }
    }
}

