/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobUpdate
implements Message<JobUpdate> {
    private static final String MESSAGE_TAG = "update";
    private Job job;
    private Type type;
    private boolean summary = false;

    public JobUpdate() {
    }

    public JobUpdate(Job job, Type type) {
        this.job = job;
        this.type = type;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public Job getJob() {
        return this.job;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Update.Builder toProto() {
        ProtoJob.Update.Builder builder = ProtoJob.Update.newBuilder();
        builder.setJob(this.job.toProto(this.summary));
        builder.setType(this.type.toProto());
        return builder;
    }

    @Override
    public JobUpdate fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Update proto = ProtoJob.Update.parseFrom(data);
        this.job = Job.parseFromProto(proto.getJob().toByteArray());
        this.type = Type.fromProto(proto.getType());
        return this;
    }

    public static enum Type {
        CREATED,
        UPDATED,
        DELETED,
        ERROR;

        static EnumMap<Type, ProtoJob.Update.Type> typeMap;

        public static Type fromProto(ProtoJob.Update.Type type) {
            return typeMap.getA(type);
        }

        public ProtoJob.Update.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoJob.Update.Type>(Type.class, ProtoJob.Update.Type.class);
        }
    }
}

