/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoLicense;
import com.google.protobuf.InvalidProtocolBufferException;

public class LicenseCommand
extends AbstractCommandMessage<LicenseCommand> {
    private static final String MESSAGE_TAG = "command";
    private Type type;
    private String license;

    public LicenseCommand() {
    }

    public LicenseCommand(Type type, String license) {
        this.type = type;
        this.license = license;
    }

    public Type getType() {
        return this.type;
    }

    public String getLicense() {
        return this.license;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoLicense.Command.Builder toProto() {
        ProtoLicense.Command.Builder builder = ProtoLicense.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toProto());
        if (this.license != null) {
            builder.setLicense(this.license);
        }
        return builder;
    }

    @Override
    public LicenseCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoLicense.Command proto = ProtoLicense.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Type.fromProto(proto.getType());
        this.license = proto.hasLicense() ? proto.getLicense() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Type type;
        private Result result = new Result();

        public Response() {
        }

        public Response(LicenseCommand query) {
            this.type = query.type;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoLicense.CommandResponse.Builder toProto() {
            ProtoLicense.CommandResponse.Builder builder = ProtoLicense.CommandResponse.newBuilder();
            builder.setType(this.type.toProto());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoLicense.CommandResponse proto = ProtoLicense.CommandResponse.parseFrom(data);
            this.type = Type.fromProto(proto.getType());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Type {
        LOAD;

        static EnumMap<Type, ProtoLicense.CommandType> typeMap;

        public static Type fromProto(ProtoLicense.CommandType type) {
            return typeMap.getA(type);
        }

        public ProtoLicense.CommandType toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoLicense.CommandType>(Type.class, ProtoLicense.CommandType.class);
        }
    }
}

