/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.License;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoLicense;
import com.google.protobuf.InvalidProtocolBufferException;

public class LicenseQuery
extends AbstractCommandMessage<LicenseQuery> {
    private static final String MESSAGE_TAG = "query";
    private Type type;
    private String userName = null;

    public LicenseQuery() {
    }

    public LicenseQuery(Type type) {
        this(type, null);
    }

    public LicenseQuery(Type type, String userName) {
        this.type = type;
        this.userName = userName;
    }

    public Type getType() {
        return this.type;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoLicense.Query.Builder toProto() {
        ProtoLicense.Query.Builder builder = ProtoLicense.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toProto());
        if (!StringUtils.isNullOrEmpty(this.userName)) {
            builder.setUserName(this.userName);
        }
        return builder;
    }

    @Override
    public LicenseQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoLicense.Query proto = ProtoLicense.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Type.fromProto(proto.getType());
        this.userName = proto.hasUserName() ? proto.getUserName() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Type type;
        private Result result = new Result();
        private String instance;
        private License license;

        public Response() {
        }

        public Response(LicenseQuery query) {
            this.type = query.type;
        }

        public Type getType() {
            return this.type;
        }

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public License getLicense() {
            return this.license;
        }

        public void setLicense(License license) {
            this.license = license;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoLicense.QueryResponse.Builder toProto() {
            ProtoLicense.QueryResponse.Builder builder = ProtoLicense.QueryResponse.newBuilder();
            builder.setType(this.type.toProto());
            builder.setResult(this.result.toProto());
            if (this.instance != null) {
                builder.setInstance(this.instance);
            }
            if (this.license != null) {
                builder.setLicense(this.license.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoLicense.QueryResponse proto = ProtoLicense.QueryResponse.parseFrom(data);
            this.type = Type.fromProto(proto.getType());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.instance = proto.hasInstance() ? proto.getInstance() : null;
            this.license = proto.hasLicense() ? new License().fromProto(proto.getLicense().toByteArray()) : null;
            return this;
        }
    }

    public static enum Type {
        USER,
        SERVER,
        INSTANCE;

        static EnumMap<Type, ProtoLicense.QueryType> typeMap;

        public static Type fromProto(ProtoLicense.QueryType type) {
            return typeMap.getA(type);
        }

        public ProtoLicense.QueryType toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoLicense.QueryType>(Type.class, ProtoLicense.QueryType.class);
        }
    }
}

