/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoLimit;
import com.google.protobuf.InvalidProtocolBufferException;

public class LimitQuery
extends AbstractCommandMessage<LimitQuery> {
    private static final String MESSAGE_TAG = "query";
    private Type type;
    private String userName = null;

    public LimitQuery() {
    }

    public LimitQuery(Type type) {
        this(type, null);
    }

    public LimitQuery(Type type, String userName) {
        this.type = type;
        this.userName = userName;
    }

    public Type getType() {
        return this.type;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoLimit.Query.Builder toProto() {
        ProtoLimit.Query.Builder builder = ProtoLimit.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toProto());
        if (!StringUtils.isNullOrEmpty(this.userName)) {
            builder.setUserName(this.userName);
        }
        return builder;
    }

    @Override
    public LimitQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoLimit.Query proto = ProtoLimit.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Type.fromProto(proto.getType());
        this.userName = proto.hasUserName() ? proto.getUserName() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Type type;
        private Limit limit;

        public Response() {
        }

        public Response(LimitQuery query) {
            this.type = query.type;
        }

        public Type getType() {
            return this.type;
        }

        public Limit getLimit() {
            return this.limit;
        }

        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoLimit.QueryResponse.Builder toProto() {
            ProtoLimit.QueryResponse.Builder builder = ProtoLimit.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setType(this.type.toProto());
            if (this.limit != null) {
                builder.setLimit(this.limit.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoLimit.QueryResponse proto = ProtoLimit.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.type = Type.fromProto(proto.getType());
            this.limit = proto.hasLimit() ? new Limit().fromProto(proto.getLimit().toByteArray()) : null;
            return this;
        }
    }

    public static enum Type {
        SERVER,
        USER;

        static EnumMap<Type, ProtoLimit.QueryType> typeMap;

        public static Type fromProto(ProtoLimit.QueryType type) {
            return typeMap.getA(type);
        }

        public ProtoLimit.QueryType toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoLimit.QueryType>(Type.class, ProtoLimit.QueryType.class);
        }
    }
}

