/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Configs;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.Logger;

public class Link
implements Message<Link> {
    static final Logger logger = LogUtils.getLogger(Link.class);
    private static final String MESSAGE_TAG = "link";
    private Type type;
    private URL url;
    private String description;

    public Link() {
    }

    public Link(Type type, String url, String description) {
        this.type = type;
        try {
            this.url = url.startsWith("http") ? new URL(url) : new URL(Configs.get("beyondcron.docs.protocol") + ":" + url);
        }
        catch (MalformedURLException e) {
            Localise.logError(logger, e.getMessage(), new Object[0]);
            this.url = null;
        }
        this.description = description;
    }

    public Link(Type type, URL url, String description) {
        this.type = type;
        this.url = url;
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.type + ": " + this.url + " - " + this.description;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCore.Link.Builder toProto() {
        ProtoCore.Link.Builder builder = ProtoCore.Link.newBuilder();
        builder.setType(this.type.toProto());
        builder.setUrl(this.url.toString());
        builder.setDescription(this.description);
        return builder;
    }

    @Override
    public Link fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCore.Link proto = ProtoCore.Link.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        try {
            this.url = new URL(proto.getUrl());
        }
        catch (MalformedURLException e) {
            Localise.logWarn(logger, e.getMessage(), new Object[0]);
            this.url = null;
        }
        this.description = proto.getDescription();
        return this;
    }

    public static enum Type {
        MANPAGE,
        GUIDE;

        static EnumMap<Type, ProtoCore.Link.Type> typeMap;

        public static Type fromProto(ProtoCore.Link.Type type) {
            return typeMap.getA(type);
        }

        public ProtoCore.Link.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoCore.Link.Type>(Type.class, ProtoCore.Link.Type.class);
        }
    }
}

