/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoPersist;
import com.google.protobuf.InvalidProtocolBufferException;

public class PersistCommand
extends AbstractCommandMessage<PersistCommand> {
    private static final String MESSAGE_TAG = "command";
    private String reference;

    public PersistCommand() {
    }

    public PersistCommand(int changeGroup, String reference) {
        this.setChangeGroup(changeGroup);
        this.reference = reference != null ? reference : "";
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoPersist.Command.Builder toProto() {
        ProtoPersist.Command.Builder builder = ProtoPersist.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeGroup(this.changeGroup);
        if (!this.reference.isEmpty()) {
            builder.setReference(this.reference);
        }
        return builder;
    }

    @Override
    public PersistCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoPersist.Command proto = ProtoPersist.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeGroup();
        this.reference = proto.getReference();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private int changeGroup;

        public Response() {
        }

        public Response(PersistCommand command) {
            this.changeGroup = command.getChangeGroup();
        }

        public int getChangeGroup() {
            return this.changeGroup;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoPersist.CommandResponse.Builder toProto() {
            ProtoPersist.CommandResponse.Builder builder = ProtoPersist.CommandResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setChangeGroup(this.changeGroup);
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoPersist.CommandResponse proto = ProtoPersist.CommandResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.changeGroup = proto.getChangeGroup();
            return this;
        }
    }
}

