/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class PropertyCommand
extends AbstractCommandMessage<PropertyCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private List<Property> properties = new ArrayList<Property>();
    private Name group;

    public PropertyCommand() {
    }

    public PropertyCommand(Name group, Action action) {
        this(group, new ArrayList<Property>(), action);
    }

    public PropertyCommand(Name group, Property property, Action action) {
        this(group, CollectionUtils.asList(property), action);
    }

    public PropertyCommand(Name group, List<Property> properties, Action action) {
        this.action = action;
        this.group = group;
        this.properties.addAll(properties);
    }

    public Action getAction() {
        return this.action;
    }

    public Name getGroup() {
        return this.group;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoProperty.Command.Builder toProto() {
        ProtoProperty.Command.Builder builder = ProtoProperty.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setGroup(this.group.toProto());
        for (Property property : this.properties) {
            builder.addProperty(property.toProto());
        }
        return builder;
    }

    @Override
    public PropertyCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProperty.Command proto = ProtoProperty.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.group = new Name().fromProto(proto.getGroup().toByteArray());
        this.properties.clear();
        for (ProtoProperty.Property property : proto.getPropertyList()) {
            this.properties.add(new Property().fromProto(property.toByteArray()));
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Action action;
        private List<Property> properties = new ArrayList<Property>();
        private Name group;

        public Response() {
        }

        public Response(PropertyCommand command) {
            this.action = command.action;
            this.group = command.group;
            this.properties = command.properties;
        }

        public Action getAction() {
            return this.action;
        }

        public Name getGroup() {
            return this.group;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoProperty.CommandResponse.Builder toProto() {
            ProtoProperty.CommandResponse.Builder builder = ProtoProperty.CommandResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setAction(this.action.toProto());
            builder.setGroup(this.group.toProto());
            for (Property property : this.properties) {
                builder.addProperty(property.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoProperty.CommandResponse proto = ProtoProperty.CommandResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.action = Action.fromProto(proto.getAction());
            this.group = new Name().fromProto(proto.getGroup().toByteArray());
            this.properties.clear();
            for (ProtoProperty.Property property : proto.getPropertyList()) {
                this.properties.add(new Property().fromProto(property.toByteArray()));
            }
            return this;
        }
    }

    public static enum Action {
        SET,
        REPLACE,
        DELETE;

        static EnumMap<Action, ProtoProperty.Command.Action> actionMap;

        public static Action fromProto(ProtoProperty.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoProperty.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoProperty.Command.Action>(Action.class, ProtoProperty.Command.Action.class);
        }
    }
}

