/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoQueue;
import com.google.protobuf.InvalidProtocolBufferException;

public class QueueCommand
extends AbstractCommandMessage<QueueCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private String name;

    public QueueCommand() {
    }

    public QueueCommand(String name, Action action) {
        this.name = name;
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoQueue.Command.Builder toProto() {
        ProtoQueue.Command.Builder builder = ProtoQueue.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name);
        return builder;
    }

    @Override
    public QueueCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoQueue.Command proto = ProtoQueue.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.name = proto.getName();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private String name;
        private Action action;

        public Response() {
        }

        public Response(QueueCommand command) {
            this.name = command.name;
            this.action = command.action;
        }

        public String getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoQueue.CommandResponse.Builder toProto() {
            ProtoQueue.CommandResponse.Builder builder = ProtoQueue.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setName(this.name);
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoQueue.CommandResponse proto = ProtoQueue.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.name = proto.getName();
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        DELETE,
        FLUSH;

        static EnumMap<Action, ProtoQueue.Command.Action> actionMap;

        public static Action fromProto(ProtoQueue.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoQueue.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoQueue.Command.Action>(Action.class, ProtoQueue.Command.Action.class);
        }
    }
}

